# Reasoning Strategies
The code of "First Heuristic Then Rational: Dynamic Use of Heuristics in Language Model Reasoning".

## Dependencies
```
conda create -n arr pytorch==1.13.1 torchvision==0.14.1 torchaudio==0.13.1 pytorch-cuda=11.6 -c pytorch -c nvidia
source activate arr
conda install -c conda-forge wandb tqdm openai lightning sentencepiece tenacity bitsandbytes
conda install -c huggingface transformers
pip install wolframalpha
```

## Make Data(GSM8K)
```
cd scripts/data/GSM8K_original_redundant
./make_data.sh [project_dir_path]
```

## Eval

### GPT-x
```
cd scripts/model/GSM8K_original_redundant
./main.sh [project_dir_path] flat gpt-3.5-turbo
```
./main.sh [project_dir_path] [flat|overlap|lexical|not_lexical|positional] [gpt-3.5-turbo|gpt-4]
```
./analysis.sh [project_dir_path] flat gpt-3.5-turbo
```

### PaLM2
```
cd scripts/model/GSM8K_original_redundant
./main_palm2.sh [project_dir_path] flat
./analysis.sh [project_dir_path] flat PaLM2
```



## Make Data(FL1)
```
cd scripts/data/numerical_data_only
./make_data.sh [project_dir_path]
```
## Eval
### GPT-x
```
cd scripts/model/numerical_data_only
./main.sh [project_dir_path] overlap flat gpt-3.5-turbo
```
./main.sh [project_dir_path] [flat|overlap|lexical|positional|logic] flat [gpt-3.5-turbo|gpt-4]
```
./analysis.sh [project_dir_path] overlap flat gpt-3.5-turbo
```

### PaLM2
```
cd scripts/model/numerical_data_only
./main_palm2.sh [project_dir_path] overlap flat
```
./main_palm2.sh [project_dir_path] [overlap|lexical|positional] flat
```
./analysis.sh [project_dir_path] overlap flat PaLM2
```




## Make Data(FL2)
```
cd scripts/data/numerical_data
./make_data.sh [project_dir_path]
```
## Eval
### GPT-x
```
cd scripts/model/numerical_data
./main.sh [project_dir_path] overlap flat gpt-3.5-turbo 0
```
./main.sh [project_dir_path] [overlap|lexical|positional] flat [gpt-3.5-turbo|gpt-4] [0|1|2]
```
./analysis.sh [project_dir_path] overlap flat gpt-3.5-turbo 0
```

### PaLM2
```
cd scripts/model/numerical_data
./main_palm2.sh [project_dir_path] overlap flat 0
```
./main_palm2.sh [project_dir_path] [overlap|lexical|positional] flat [0|1|2]
```
./analysis.sh [project_dir_path] overlap flat PaLM2 0
```
