/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.PrettyLoggable;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;

public class PrettyLogger {
    private static final Redwood.RedwoodChannels DEFAULT_CHANNELS = new Redwood.RedwoodChannels(new Object[]{Redwood.FORCE});

    private PrettyLogger() {
    }

    public static void log(Object obj) {
        PrettyLogger.log(obj.getClass().getSimpleName(), obj);
    }

    public static void log(String description, Object obj) {
        PrettyLogger.log(DEFAULT_CHANNELS, description, obj);
    }

    public static void log(Redwood.RedwoodChannels channels, Object obj) {
        PrettyLogger.log(channels, obj.getClass().getSimpleName(), obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> void log(Redwood.RedwoodChannels channels, String description, Object obj) {
        if (obj instanceof Map) {
            PrettyLogger.log(channels, description, (Map)obj);
            return;
        } else if (obj instanceof PrettyLoggable) {
            ((PrettyLoggable)obj).prettyLog(channels, description);
            return;
        } else if (obj instanceof Dictionary) {
            PrettyLogger.log(channels, description, (Dictionary)obj);
            return;
        } else if (obj instanceof Iterable) {
            PrettyLogger.log(channels, description, (Iterable)obj);
            return;
        } else if (obj.getClass().isArray()) {
            Object[] arrayCopy;
            if (obj.getClass().getComponentType().isPrimitive()) {
                Class<?> componentClass = obj.getClass().getComponentType();
                if (Boolean.TYPE.isAssignableFrom(componentClass)) {
                    arrayCopy = new Object[((boolean[])obj).length];
                    for (int i = 0; i < arrayCopy.length; ++i) {
                        arrayCopy[i] = ((boolean[])obj)[i];
                    }
                } else if (Byte.TYPE.isAssignableFrom(componentClass)) {
                    arrayCopy = new Object[((byte[])obj).length];
                    for (int i = 0; i < arrayCopy.length; ++i) {
                        arrayCopy[i] = ((byte[])obj)[i];
                    }
                } else if (Character.TYPE.isAssignableFrom(componentClass)) {
                    arrayCopy = new Object[((char[])obj).length];
                    for (int i = 0; i < arrayCopy.length; ++i) {
                        arrayCopy[i] = Character.valueOf(((char[])obj)[i]);
                    }
                } else if (Short.TYPE.isAssignableFrom(componentClass)) {
                    arrayCopy = new Object[((short[])obj).length];
                    for (int i = 0; i < arrayCopy.length; ++i) {
                        arrayCopy[i] = ((short[])obj)[i];
                    }
                } else if (Integer.TYPE.isAssignableFrom(componentClass)) {
                    arrayCopy = new Object[((int[])obj).length];
                    for (int i = 0; i < arrayCopy.length; ++i) {
                        arrayCopy[i] = ((int[])obj)[i];
                    }
                } else if (Long.TYPE.isAssignableFrom(componentClass)) {
                    arrayCopy = new Object[((long[])obj).length];
                    for (int i = 0; i < arrayCopy.length; ++i) {
                        arrayCopy[i] = ((long[])obj)[i];
                    }
                } else if (Float.TYPE.isAssignableFrom(componentClass)) {
                    arrayCopy = new Object[((float[])obj).length];
                    for (int i = 0; i < arrayCopy.length; ++i) {
                        arrayCopy[i] = Float.valueOf(((float[])obj)[i]);
                    }
                } else {
                    if (!Double.TYPE.isAssignableFrom(componentClass)) throw new IllegalStateException("I forgot about the primitive class: " + componentClass);
                    arrayCopy = new Object[((double[])obj).length];
                    for (int i = 0; i < arrayCopy.length; ++i) {
                        arrayCopy[i] = ((double[])obj)[i];
                    }
                }
            } else {
                arrayCopy = (Object[])obj;
            }
            PrettyLogger.log(channels, description, arrayCopy);
            return;
        } else {
            if (!description.equals("")) {
                description = description + ": ";
            }
            channels.log(description + obj);
        }
    }

    public static boolean dispatchable(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof PrettyLoggable || obj instanceof Map || obj instanceof Dictionary || obj instanceof Iterable || obj.getClass().isArray();
    }

    private static <K, V> void log(Redwood.RedwoodChannels channels, String description, Map<K, V> mapping) {
        Redwood.startTrack(description);
        if (mapping == null) {
            channels.log("(mapping is null)");
        } else if (mapping.size() == 0) {
            channels.log("(empty)");
        } else {
            LinkedList<K> keys = new LinkedList<K>();
            for (K key : mapping.keySet()) {
                keys.add(key);
            }
            Collections.sort(keys, new Comparator<K>(){

                @Override
                public int compare(K a, K b) {
                    if (a != null && Comparable.class.isAssignableFrom(a.getClass())) {
                        return ((Comparable)a).compareTo(b);
                    }
                    return 0;
                }
            });
            int entryCounter = 0;
            for (Object key : keys) {
                V value = mapping.get(key);
                if (!PrettyLogger.dispatchable(key) && PrettyLogger.dispatchable(value)) {
                    PrettyLogger.log(channels, key.toString(), value);
                } else if (PrettyLogger.dispatchable(key) || PrettyLogger.dispatchable(value)) {
                    Redwood.startTrack("Entry " + entryCounter);
                    if (PrettyLogger.dispatchable(key)) {
                        PrettyLogger.log(channels, "Key", key);
                    } else {
                        channels.logf("Key %s", key);
                    }
                    if (PrettyLogger.dispatchable(value)) {
                        PrettyLogger.log(channels, "Value", value);
                    } else {
                        channels.logf("Value %s", value);
                    }
                    Redwood.endTrack("Entry " + entryCounter);
                } else {
                    channels.logf("%s = %s", key, value);
                }
                ++entryCounter;
            }
        }
        Redwood.endTrack(description);
    }

    private static <K, V> void log(Redwood.RedwoodChannels channels, String description, Dictionary<K, V> dict) {
        Map<K, V> map = Generics.newHashMap();
        Enumeration<K> keys = dict.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            V value = dict.get(key);
            map.put(key, value);
        }
        PrettyLogger.log(channels, description, map);
    }

    private static <T> void log(Redwood.RedwoodChannels channels, String description, Iterable<T> iterable) {
        Redwood.startTrack(description);
        if (iterable == null) {
            channels.log("(iterable is null)");
        } else {
            int index = 0;
            for (T item : iterable) {
                if (PrettyLogger.dispatchable(item) && item != iterable) {
                    PrettyLogger.log(channels, "Index " + index, item);
                } else {
                    channels.logf("Index %d: %s", index, item == iterable ? "...<infinite loop>" : item);
                }
                ++index;
            }
            if (index == 0) {
                channels.log("(empty)");
            }
        }
        Redwood.endTrack(description);
    }

    private static <T> void log(Redwood.RedwoodChannels channels, String description, T[] array) {
        Redwood.startTrack(description);
        if (array == null) {
            channels.log("(array is null)");
        } else if (array.length == 0) {
            channels.log("(empty)");
        } else {
            int index = 0;
            for (T item : array) {
                if (PrettyLogger.dispatchable(item)) {
                    PrettyLogger.log(channels, "Index " + index, item);
                } else {
                    channels.logf("Index %d: %s", index, item);
                }
                ++index;
            }
        }
        Redwood.endTrack(description);
    }
}

