/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import java.util.Map;

public abstract class TsurgeonPattern {
    static final TsurgeonPattern[] EMPTY_TSURGEON_PATTERN_ARRAY = new TsurgeonPattern[0];
    final String label;
    final TsurgeonPattern[] children;
    TsurgeonPattern root;

    protected void setRoot(TsurgeonPatternRoot root) {
        this.root = root;
        for (TsurgeonPattern child : this.children) {
            child.setRoot(root);
        }
    }

    TsurgeonPattern(String label, TsurgeonPattern[] children) {
        this.label = label;
        this.children = children;
    }

    public String toString() {
        StringBuilder resultSB = new StringBuilder();
        resultSB.append(this.label);
        if (this.children.length > 0) {
            resultSB.append('(');
            for (int i = 0; i < this.children.length; ++i) {
                resultSB.append(this.children[i]);
                if (i >= this.children.length - 1) continue;
                resultSB.append(", ");
            }
            resultSB.append(')');
        }
        return resultSB.toString();
    }

    public TsurgeonMatcher matcher() {
        throw new UnsupportedOperationException("Only the root node can produce the top level matcher");
    }

    public abstract TsurgeonMatcher matcher(Map<String, Tree> var1, CoindexationGenerator var2);
}

