/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CoindexationGenerator {
    private static final Pattern coindexationPattern = Pattern.compile(".+?-([0-9]+)$");
    private int lastIndex;

    CoindexationGenerator() {
    }

    public void setLastIndex(Tree t) {
        this.lastIndex = 0;
        for (Tree node : t) {
            Matcher m;
            String value = node.label().value();
            if (value == null || !(m = coindexationPattern.matcher(value)).find()) continue;
            int thisIndex = 0;
            try {
                thisIndex = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.lastIndex = Math.max(thisIndex, this.lastIndex);
        }
    }

    public int generateIndex() {
        ++this.lastIndex;
        return this.lastIndex;
    }
}

