/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.TregexPatternCompiler;

public class DateTreeTransformer
implements TreeTransformer {
    static final String MONTH_REGEX = "January|February|March|April|May|June|July|August|September|October|November|December|Jan\\.|Feb\\.|Mar\\.|Apr\\.|Aug\\.|Sep\\.|Sept\\.|Oct\\.|Nov\\.|Dec\\.";
    static final TregexPattern tregexMonthYear = TregexPatternCompiler.defaultCompiler.compile("NP=root <1 (NP <: (NNP=month <: /January|February|March|April|May|June|July|August|September|October|November|December|Jan\\.|Feb\\.|Mar\\.|Apr\\.|Aug\\.|Sep\\.|Sept\\.|Oct\\.|Nov\\.|Dec\\./)) <2 (NP=yearnp <: (CD=year <: __)) : =root <- =yearnp");
    static final TregexPattern tregexMonthDayYear = TregexPatternCompiler.defaultCompiler.compile("NP=root <1 (NP=monthdayroot <1 (NNP=month <: /January|February|March|April|May|June|July|August|September|October|November|December|Jan\\.|Feb\\.|Mar\\.|Apr\\.|Aug\\.|Sep\\.|Sept\\.|Oct\\.|Nov\\.|Dec\\./) <2 (CD=day <: __)) <2 (/^,$/=comma <: /^,$/) <3 (NP=yearroot <: (CD=year <: __)) : (=root <- =yearroot) : (=monthdayroot <- =day)");

    @Override
    public Tree transformTree(Tree t) {
        Tree month;
        Tree root;
        TregexMatcher matcher = tregexMonthYear.matcher(t);
        while (matcher.find()) {
            root = matcher.getNode("root");
            month = matcher.getNode("month");
            Tree year = matcher.getNode("year");
            Tree[] children = new Tree[]{month, year};
            root.setChildren(children);
            matcher = tregexMonthYear.matcher(t);
        }
        matcher = tregexMonthDayYear.matcher(t);
        while (matcher.find()) {
            root = matcher.getNode("root");
            month = matcher.getNode("month");
            Tree day = matcher.getNode("day");
            Tree comma = matcher.getNode("comma");
            Tree year = matcher.getNode("year");
            Tree[] children = new Tree[]{month, day, comma, year};
            root.setChildren(children);
            matcher = tregexMonthDayYear.matcher(t);
        }
        return t;
    }
}

