/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.DictionaryExtractor;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import java.util.regex.Pattern;

public class ExtractorVerbalVBNZero
extends DictionaryExtractor {
    private static final String vbnTag = "VBN";
    private static final String vbdTag = "VBD";
    private static final String jjTag = "JJ";
    private static final String edSuff = "ed";
    private static final String enSuff = "en";
    private static final String oneSt = "1";
    private static final String naWord = "NA";
    private final int bound;
    private static final Pattern stopper = Pattern.compile("(?i:and|or|but|,|;|-|--)");
    private static final Pattern vbnWord = Pattern.compile("(?i:have|has|having|had|is|am|are|was|were|be|being|been|'ve|'s|s|'d|'re|'m|gotten|got|gets|get|getting)");
    private static final long serialVersionUID = -5881204185400060636L;

    public ExtractorVerbalVBNZero(int bound) {
        this.bound = bound;
    }

    @Override
    public boolean precondition(String tag) {
        System.err.println("VBN: Testing precondition on " + tag + ": " + (tag.equals(vbnTag) || tag.equals(vbdTag) || tag.equals(jjTag)));
        return tag.equals(vbnTag) || tag.equals(vbdTag) || tag.equals(jjTag);
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String word2;
        String cword = pH.getWord(h, 0);
        int allCount = this.dict.sum(cword);
        int vBNCount = this.dict.getCount(cword, vbnTag);
        int vBDCount = this.dict.getCount(cword, vbdTag);
        if (allCount == 0 && !cword.endsWith(edSuff) && !cword.endsWith(enSuff)) {
            return "0";
        }
        if (allCount > 0 && vBNCount + vBDCount <= allCount / 100) {
            return "0";
        }
        String lastverb = naWord;
        for (int index = -1; index >= -this.bound && !naWord.equals(word2 = pH.getWord(h, index)) && !stopper.matcher(word2).matches(); --index) {
            if (vbnWord.matcher(word2).matches()) {
                lastverb = word2;
                break;
            }
            --index;
        }
        if (!lastverb.equals(naWord)) {
            System.err.println("VBN: For " + cword + ", found preceding VBN cue " + lastverb);
            return oneSt;
        }
        return "0";
    }

    @Override
    public String toString() {
        return "ExtractorVerbalVBNZero(bound=" + this.bound + ')';
    }
}

