/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.tagger.maxent.AmbiguityClasses;
import edu.stanford.nlp.tagger.maxent.CountWrapper;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.tagger.maxent.TagCount;
import edu.stanford.nlp.util.Generics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class Dictionary {
    private final Map<String, TagCount> dict = Generics.newHashMap();
    private final Map<Integer, CountWrapper> partTakingVerbs = Generics.newHashMap();
    private static final String naWord = "NA";
    private static final boolean VERBOSE = false;

    void fillWordTagCounts(Map<String, IntCounter<String>> wordTagCounts) {
        for (String word : wordTagCounts.keySet()) {
            TagCount count = new TagCount(wordTagCounts.get(word));
            this.dict.put(word, count);
        }
    }

    protected void addVThatTaking(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            this.partTakingVerbs.get(i).incThat();
        } else {
            this.partTakingVerbs.put(i, new CountWrapper(verb, 0, 1, 0, 0));
        }
    }

    protected int getCountPart(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            return this.partTakingVerbs.get(i).getCountPart();
        }
        return 0;
    }

    protected int getCountThat(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            return this.partTakingVerbs.get(i).getCountThat();
        }
        return 0;
    }

    protected int getCountIn(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            return this.partTakingVerbs.get(i).getCountIn();
        }
        return 0;
    }

    protected int getCountRB(String verb) {
        int i = verb.hashCode();
        if (this.partTakingVerbs.containsKey(i)) {
            return this.partTakingVerbs.get(i).getCountRB();
        }
        return 0;
    }

    protected int getCount(String word, String tag) {
        TagCount count = this.dict.get(word);
        if (count == null) {
            return 0;
        }
        return count.get(tag);
    }

    protected String[] getTags(String word) {
        TagCount count = this.get(word);
        if (count == null) {
            return null;
        }
        return count.getTags();
    }

    protected TagCount get(String word) {
        return this.dict.get(word);
    }

    String getFirstTag(String word) {
        TagCount count = this.dict.get(word);
        if (count != null) {
            return count.getFirstTag();
        }
        return null;
    }

    protected int sum(String word) {
        TagCount count = this.dict.get(word);
        if (count != null) {
            return count.sum();
        }
        return 0;
    }

    boolean isUnknown(String word) {
        return !this.dict.containsKey(word);
    }

    void save(DataOutputStream file) {
        String[] arr = this.dict.keySet().toArray(new String[this.dict.keySet().size()]);
        try {
            file.writeInt(arr.length);
            System.err.println("Saving dictionary of " + arr.length + " words ...");
            for (String word : arr) {
                TagCount count = this.get(word);
                file.writeUTF(word);
                count.save(file);
            }
            Integer[] arrverbs = this.partTakingVerbs.keySet().toArray(new Integer[this.partTakingVerbs.keySet().size()]);
            file.writeInt(arrverbs.length);
            for (Integer iO : arrverbs) {
                CountWrapper tC = this.partTakingVerbs.get(iO);
                file.writeInt(iO);
                tC.save(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read(DataInputStream rf, String filename) throws IOException {
        int maxNumTags = 0;
        int len = rf.readInt();
        for (int i = 0; i < len; ++i) {
            String word = rf.readUTF();
            TagCount count = TagCount.readTagCount(rf);
            int numTags = count.numTags();
            if (numTags > maxNumTags) {
                maxNumTags = numTags;
            }
            this.dict.put(word, count);
        }
    }

    private void readTags(DataInputStream rf) throws IOException {
        int maxNumTags = 0;
        int len = rf.readInt();
        for (int i = 0; i < len; ++i) {
            String word = rf.readUTF();
            TagCount count = TagCount.readTagCount(rf);
            int numTags = count.numTags();
            if (numTags > maxNumTags) {
                maxNumTags = numTags;
            }
            this.dict.put(word, count);
        }
    }

    protected void read(String filename) {
        try {
            DataInputStream rf = IOUtils.getDataInputStream(filename);
            this.read(rf, filename);
            int len1 = rf.readInt();
            for (int i = 0; i < len1; ++i) {
                int iO = rf.readInt();
                CountWrapper tC = new CountWrapper();
                tC.read(rf);
                this.partTakingVerbs.put(iO, tC);
            }
            rf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void read(DataInputStream file) {
        try {
            this.readTags(file);
            int len1 = file.readInt();
            for (int i = 0; i < len1; ++i) {
                int iO = file.readInt();
                CountWrapper tC = new CountWrapper();
                tC.read(file);
                this.partTakingVerbs.put(iO, tC);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setAmbClasses(AmbiguityClasses ambClasses, int veryCommonWordThresh, TTags ttags) {
        for (Map.Entry<String, TagCount> entry : this.dict.entrySet()) {
            String w = entry.getKey();
            TagCount count = entry.getValue();
            int ambClassId = ambClasses.getClass(w, this, veryCommonWordThresh, ttags);
            count.setAmbClassId(ambClassId);
        }
    }

    protected int getAmbClass(String word) {
        if (word.equals(naWord)) {
            return -2;
        }
        if (this.get(word) == null) {
            return -1;
        }
        return this.get(word).getAmbClassId();
    }

    public static void main(String[] args) {
        String s = "word";
        String tag = "tag";
        Dictionary d = new Dictionary();
        System.out.println(d.getCount(s, tag));
        System.out.println(d.getFirstTag(s));
    }
}

