/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.domains.ace.reader;

import edu.stanford.nlp.ie.machinereading.common.SimpleTokenize;
import edu.stanford.nlp.ie.machinereading.domains.ace.AceReader;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceCharSeq;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceDomReader;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceElement;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntity;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEntityMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEvent;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceEventMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelation;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceRelationMention;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceSentenceSegmenter;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.AceToken;
import edu.stanford.nlp.ie.machinereading.domains.ace.reader.MatchException;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AceDocument
extends AceElement {
    private String mPrefix;
    private String mSource;
    private Map<String, AceEntity> mEntities = Generics.newHashMap();
    private Map<String, AceEntityMention> mEntityMentions = Generics.newHashMap();
    private ArrayList<ArrayList<AceEntityMention>> mSentenceEntityMentions = new ArrayList();
    private Map<String, AceRelation> mRelations = Generics.newHashMap();
    private Map<String, AceRelationMention> mRelationMentions = Generics.newHashMap();
    private ArrayList<ArrayList<AceRelationMention>> mSentenceRelationMentions = new ArrayList();
    private Map<String, AceEvent> mEvents = Generics.newHashMap();
    private Map<String, AceEventMention> mEventMentions = Generics.newHashMap();
    private ArrayList<ArrayList<AceEventMention>> mSentenceEventMentions = new ArrayList();
    private Vector<AceToken> mTokens = new Vector();
    private List<List<AceToken>> mSentences;
    private String mRawBuffer;
    static Logger mLog = Logger.getLogger(AceReader.class.getName());
    public static final String XML_EXT = ".apf.xml";
    public static final String ORIG_EXT = ".sgm";

    public AceDocument(String id) {
        super(id);
    }

    public void setPrefix(String p) {
        this.mPrefix = p;
        this.setSource(this.mPrefix);
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public void setSource(String p) {
        if (p.indexOf("bc/") >= 0) {
            this.mSource = "broadcast conversation";
        } else if (p.indexOf("bn/") >= 0) {
            this.mSource = "broadcast news";
        } else if (p.indexOf("cts/") >= 0) {
            this.mSource = "telephone";
        } else if (p.indexOf("nw/") >= 0) {
            this.mSource = "newswire";
        } else if (p.indexOf("un/") >= 0) {
            this.mSource = "usenet";
        } else if (p.indexOf("wl/") >= 0) {
            this.mSource = "weblog";
        } else {
            System.err.println("WARNING: Unknown source for doc: " + p);
            this.mSource = "none";
        }
    }

    public int getSentenceCount() {
        return this.mSentenceEntityMentions.size();
    }

    public ArrayList<AceEntityMention> getEntityMentions(int sent) {
        return this.mSentenceEntityMentions.get(sent);
    }

    public ArrayList<ArrayList<AceEntityMention>> getAllEntityMentions() {
        return this.mSentenceEntityMentions;
    }

    public ArrayList<AceRelationMention> getRelationMentions(int sent) {
        return this.mSentenceRelationMentions.get(sent);
    }

    public ArrayList<ArrayList<AceRelationMention>> getAllRelationMentions() {
        return this.mSentenceRelationMentions;
    }

    public ArrayList<AceEventMention> getEventMentions(int sent) {
        return this.mSentenceEventMentions.get(sent);
    }

    public ArrayList<ArrayList<AceEventMention>> getAllEventMentions() {
        return this.mSentenceEventMentions;
    }

    public AceEntity getEntity(String id) {
        return this.mEntities.get(id);
    }

    public Set<String> getKeySetEntities() {
        return this.mEntities.keySet();
    }

    public void addEntity(AceEntity e) {
        this.mEntities.put(e.getId(), e);
    }

    public Map<String, AceEntityMention> getEntityMentions() {
        return this.mEntityMentions;
    }

    public AceEntityMention getEntityMention(String id) {
        return this.mEntityMentions.get(id);
    }

    public void addEntityMention(AceEntityMention em) {
        this.mEntityMentions.put(em.getId(), em);
    }

    public AceRelation getRelation(String id) {
        return this.mRelations.get(id);
    }

    public void addRelation(AceRelation r) {
        this.mRelations.put(r.getId(), r);
    }

    public Map<String, AceRelationMention> getRelationMentions() {
        return this.mRelationMentions;
    }

    public AceRelationMention getRelationMention(String id) {
        return this.mRelationMentions.get(id);
    }

    public void addRelationMention(AceRelationMention e) {
        this.mRelationMentions.put(e.getId(), e);
    }

    public AceEvent getEvent(String id) {
        return this.mEvents.get(id);
    }

    public void addEvent(AceEvent r) {
        this.mEvents.put(r.getId(), r);
    }

    public Map<String, AceEventMention> getEventMentions() {
        return this.mEventMentions;
    }

    public AceEventMention getEventMention(String id) {
        return this.mEventMentions.get(id);
    }

    public void addEventMention(AceEventMention e) {
        this.mEventMentions.put(e.getId(), e);
    }

    public void addToken(AceToken t) {
        this.mTokens.add(t);
    }

    public int getTokenCount() {
        return this.mTokens.size();
    }

    public AceToken getToken(int i) {
        return this.mTokens.get(i);
    }

    public List<AceToken> getSentence(int index) {
        return this.mSentences.get(index);
    }

    public List<List<AceToken>> getSentences() {
        return this.mSentences;
    }

    public void setSentences(List<List<AceToken>> sentences) {
        this.mSentences = sentences;
    }

    public String toString() {
        return this.toXml(0);
    }

    public String toXml(int offset) {
        StringBuffer buffer = new StringBuffer();
        AceDocument.appendOffset(buffer, offset);
        buffer.append("<?xml version=\"1.0\"?>\n");
        AceDocument.appendOffset(buffer, offset);
        buffer.append("<!DOCTYPE source_file SYSTEM \"apf.v5.1.2.dtd\">\n");
        AceDocument.appendOffset(buffer, offset);
        buffer.append("<source_file URI=\"" + this.mId + ".sgm\" SOURCE=\"" + this.mSource + "\" TYPE=\"text\" AUTHOR=\"LDC\" ENCODING=\"UTF-8\">\n");
        AceDocument.appendOffset(buffer, offset);
        buffer.append("<document DOCID=\"" + this.getId() + "\">\n");
        Set<String> entKeys = this.mEntities.keySet();
        for (String key : entKeys) {
            AceEntity e = this.mEntities.get(key);
            buffer.append(e.toXml(offset));
            buffer.append("\n");
        }
        Set<String> relKeys = this.mRelations.keySet();
        for (String key : relKeys) {
            AceRelation r = this.mRelations.get(key);
            if (r.getType().equals("nil")) continue;
            buffer.append(r.toXml(offset));
            buffer.append("\n");
        }
        AceDocument.appendOffset(buffer, offset);
        buffer.append("</document>\n");
        AceDocument.appendOffset(buffer, offset);
        buffer.append("</source_file>\n");
        return buffer.toString();
    }

    private String tokensWithByteSpan(int start, int end) {
        StringBuffer buf = new StringBuffer();
        boolean doPrint = false;
        buf.append("...");
        for (int i = 0; i < this.mTokens.size(); ++i) {
            if (!doPrint && this.mTokens.get(i).getByteOffset().start() > start - 20 && this.mTokens.get(i).getByteOffset().end() < end) {
                doPrint = true;
            } else if (doPrint && this.mTokens.get(i).getByteOffset().start() > end + 20) {
                doPrint = false;
            }
            if (!doPrint) continue;
            buf.append(" " + this.mTokens.get(i).display());
        }
        buf.append("...");
        return buf.toString();
    }

    public void matchCharSeqs(String filePrefix) {
        Set<String> keys = this.mEntityMentions.keySet();
        for (String key : keys) {
            AceEntityMention m = this.mEntityMentions.get(key);
            try {
                m.getHead().match(this.mTokens);
            }
            catch (MatchException e) {
                mLog.severe("READER ERROR: Failed to match entity mention head: [" + m.getHead().getText() + ", " + m.getHead().getByteStart() + ", " + m.getHead().getByteEnd() + "]");
                mLog.severe("Document tokens: " + this.tokensWithByteSpan(m.getHead().getByteStart(), m.getHead().getByteEnd()));
                mLog.severe("Document prefix: " + filePrefix);
                System.exit(1);
            }
            try {
                m.getExtent().match(this.mTokens);
            }
            catch (MatchException e) {
                mLog.severe("READER ERROR: Failed to match entity mention extent: [" + m.getExtent().getText() + ", " + m.getExtent().getByteStart() + ", " + m.getExtent().getByteEnd() + "]");
                mLog.severe("Document tokens: " + this.tokensWithByteSpan(m.getExtent().getByteStart(), m.getExtent().getByteEnd()));
                System.exit(1);
            }
            m.detectHeadToken(this);
        }
        Set<String> eventKeys = this.mEventMentions.keySet();
        for (String key : eventKeys) {
            AceEventMention m = this.mEventMentions.get(key);
            try {
                m.getExtent().match(this.mTokens);
            }
            catch (MatchException e) {
                mLog.severe("READER ERROR: Failed to match event mention extent: [" + m.getExtent().getText() + ", " + m.getExtent().getByteStart() + ", " + m.getExtent().getByteEnd() + "]");
                mLog.severe("Document tokens: " + this.tokensWithByteSpan(m.getExtent().getByteStart(), m.getExtent().getByteEnd()));
                System.exit(1);
            }
        }
    }

    public static AceDocument parseDocument(String prefix, boolean usePredictedBoundaries) throws IOException, SAXException, ParserConfigurationException {
        mLog.fine("Reading document " + prefix);
        AceDocument doc = null;
        if (!usePredictedBoundaries) {
            doc = AceDomReader.parseDocument(new File(prefix + XML_EXT));
        } else {
            int lastSlash = prefix.lastIndexOf(File.separator);
            assert (lastSlash > 0 && lastSlash < prefix.length() - 1);
            String id = prefix.substring(lastSlash + 1);
            doc = new AceDocument(id);
        }
        doc.setPrefix(prefix);
        String trueCasedFileName = prefix + ORIG_EXT + ".truecase";
        if (new File(trueCasedFileName).exists()) {
            mLog.severe("Using truecased file: " + trueCasedFileName);
            doc.readRawBytes(trueCasedFileName);
        } else {
            doc.readRawBytes(prefix + ORIG_EXT);
        }
        int offsetToSubtract = 0;
        List<List<AceToken>> sentences = AceSentenceSegmenter.tokenizeAndSegmentSentences(prefix);
        doc.setSentences(sentences);
        for (List<AceToken> sentence : sentences) {
            for (AceToken token : sentence) {
                offsetToSubtract = token.adjustPhrasePositions(offsetToSubtract, token.getLiteral());
                doc.addToken(token);
            }
        }
        doc.matchCharSeqs(prefix);
        Set<String> entityKeys = doc.mEntityMentions.keySet();
        for (String key : entityKeys) {
            AceEntityMention em = doc.mEntityMentions.get(key);
            int sentence = doc.mTokens.get(em.getHead().getTokenStart()).getSentence();
            while (sentence >= doc.mSentenceEntityMentions.size()) {
                doc.mSentenceEntityMentions.add(new ArrayList());
                doc.mSentenceRelationMentions.add(new ArrayList());
                doc.mSentenceEventMentions.add(new ArrayList());
            }
            ArrayList<AceEntityMention> sentEnts = doc.mSentenceEntityMentions.get(sentence);
            boolean added = false;
            for (int i = 0; i < sentEnts.size(); ++i) {
                AceEntityMention crt = sentEnts.get(i);
                if (crt.getHead().getTokenStart() <= em.getHead().getTokenStart() && (crt.getHead().getTokenStart() != em.getHead().getTokenStart() || crt.getHead().getTokenEnd() <= em.getHead().getTokenEnd())) continue;
                sentEnts.add(i, em);
                added = true;
                break;
            }
            if (added) continue;
            sentEnts.add(em);
        }
        Set<String> relKeys = doc.mRelationMentions.keySet();
        for (String key : relKeys) {
            AceRelationMention rm = doc.mRelationMentions.get(key);
            int sentence = doc.mTokens.get(rm.getArg(0).getHead().getTokenStart()).getSentence();
            ArrayList<AceRelationMention> sentRels = doc.mSentenceRelationMentions.get(sentence);
            boolean added = false;
            for (int i = 0; i < sentRels.size(); ++i) {
                AceRelationMention crt = sentRels.get(i);
                if (crt.getMinTokenStart() <= rm.getMinTokenStart() && (crt.getMinTokenStart() != rm.getMinTokenStart() || crt.getMaxTokenEnd() <= rm.getMaxTokenEnd())) continue;
                sentRels.add(i, rm);
                added = true;
                break;
            }
            if (added) continue;
            sentRels.add(rm);
        }
        Set<String> eventKeys = doc.mEventMentions.keySet();
        for (String key : eventKeys) {
            AceEventMention em = doc.mEventMentions.get(key);
            int sentence = doc.mTokens.get(em.getMinTokenStart()).getSentence();
            while (sentence >= doc.mSentenceEntityMentions.size()) {
                doc.mSentenceEntityMentions.add(new ArrayList());
                doc.mSentenceRelationMentions.add(new ArrayList());
                doc.mSentenceEventMentions.add(new ArrayList());
            }
            ArrayList<AceEventMention> sentEvents = doc.mSentenceEventMentions.get(sentence);
            boolean added = false;
            for (int i = 0; i < sentEvents.size(); ++i) {
                AceEventMention crt = sentEvents.get(i);
                if (crt.getMinTokenStart() <= em.getMinTokenStart() && (crt.getMinTokenStart() != em.getMinTokenStart() || crt.getMaxTokenEnd() <= em.getMaxTokenEnd())) continue;
                sentEvents.add(i, em);
                added = true;
                break;
            }
            if (added) continue;
            sentEvents.add(em);
        }
        return doc;
    }

    public static AceDocument parseDocument(String prefix, boolean usePredictedBoundaries, String AceVersion) throws IOException, SAXException, ParserConfigurationException {
        mLog.fine("Reading document " + prefix);
        AceDocument doc = null;
        if (!usePredictedBoundaries) {
            doc = AceDomReader.parseDocument(new File(prefix + XML_EXT));
        } else {
            int lastSlash = prefix.lastIndexOf(File.separator);
            assert (lastSlash > 0 && lastSlash < prefix.length() - 1);
            String id = prefix.substring(lastSlash + 1);
            doc = new AceDocument(id);
        }
        doc.setPrefix(prefix);
        String trueCasedFileName = prefix + ORIG_EXT + ".truecase";
        if (new File(trueCasedFileName).exists()) {
            mLog.severe("Using truecased file: " + trueCasedFileName);
            doc.readRawBytes(trueCasedFileName);
        } else {
            doc.readRawBytes(prefix + ORIG_EXT);
        }
        int offsetToSubtract = 0;
        List<List<AceToken>> sentences = AceSentenceSegmenter.tokenizeAndSegmentSentences(prefix);
        doc.setSentences(sentences);
        for (List<AceToken> sentence : sentences) {
            for (AceToken token : sentence) {
                offsetToSubtract = token.adjustPhrasePositions(offsetToSubtract, token.getLiteral());
                doc.addToken(token);
            }
        }
        doc.matchCharSeqs(prefix);
        Set<String> entityKeys = doc.mEntityMentions.keySet();
        for (String key : entityKeys) {
            AceEntityMention em = doc.mEntityMentions.get(key);
            int sentence = doc.mTokens.get(em.getHead().getTokenStart()).getSentence();
            while (sentence >= doc.mSentenceEntityMentions.size()) {
                doc.mSentenceEntityMentions.add(new ArrayList());
                doc.mSentenceRelationMentions.add(new ArrayList());
                doc.mSentenceEventMentions.add(new ArrayList());
            }
            ArrayList<AceEntityMention> sentEnts = doc.mSentenceEntityMentions.get(sentence);
            boolean added = false;
            for (int i = 0; i < sentEnts.size(); ++i) {
                AceEntityMention crt = sentEnts.get(i);
                if (crt.getHead().getTokenStart() <= em.getHead().getTokenStart() && (crt.getHead().getTokenStart() != em.getHead().getTokenStart() || crt.getHead().getTokenEnd() <= em.getHead().getTokenEnd())) continue;
                sentEnts.add(i, em);
                added = true;
                break;
            }
            if (added) continue;
            sentEnts.add(em);
        }
        return doc;
    }

    public void constructSentenceRelationMentions() {
        Set<String> relKeys = this.mRelationMentions.keySet();
        for (String key : relKeys) {
            AceRelationMention rm = this.mRelationMentions.get(key);
            int sentence = this.mTokens.get(rm.getArg(0).getHead().getTokenStart()).getSentence();
            ArrayList<AceRelationMention> sentRels = this.mSentenceRelationMentions.get(sentence);
            boolean added = false;
            for (int i = 0; i < sentRels.size(); ++i) {
                AceRelationMention crt = sentRels.get(i);
                if (crt.getMinTokenStart() <= rm.getMinTokenStart() && (crt.getMinTokenStart() != rm.getMinTokenStart() || crt.getMaxTokenEnd() <= rm.getMaxTokenEnd())) continue;
                sentRels.add(i, rm);
                added = true;
                break;
            }
            if (added) continue;
            sentRels.add(rm);
        }
    }

    public boolean sameChunk(int left, int right) {
        for (int i = right; i > left; --i) {
            String chunk = AceToken.OTHERS.get(this.getToken(i).getChunk());
            if (!chunk.startsWith("I-")) {
                return false;
            }
            String word = AceToken.WORDS.get(this.getToken(i).getWord());
            if (!word.equals(",") && !word.equals("(") && !word.equals("-")) continue;
            return false;
        }
        String leftChunk = AceToken.OTHERS.get(this.getToken(left).getChunk());
        return !leftChunk.equals("O");
    }

    public boolean isChunkHead(int pos) {
        String next = AceToken.OTHERS.get(this.getToken(pos + 1).getChunk());
        return !next.startsWith("I-");
    }

    public int findChunkEnd(int pos) {
        String crt = AceToken.OTHERS.get(this.getToken(pos).getChunk());
        if (crt.equals("O")) {
            return pos;
        }
        ++pos;
        while (pos < this.getTokenCount() && (crt = AceToken.OTHERS.get(this.getToken(pos).getChunk())).startsWith("I-")) {
            ++pos;
        }
        return pos - 1;
    }

    public int findChunkStart(int pos) {
        String crt = AceToken.OTHERS.get(this.getToken(pos).getChunk());
        if (crt.equals("O") || crt.startsWith("B-")) {
            return pos;
        }
        --pos;
        while (pos >= 0 && !(crt = AceToken.OTHERS.get(this.getToken(pos).getChunk())).startsWith("B-")) {
            --pos;
        }
        return pos;
    }

    public boolean isApposition(int left, int right) {
        String comma;
        int leftEnd = this.findChunkEnd(left);
        int rightStart = this.findChunkStart(right);
        if (rightStart == leftEnd + 1) {
            return true;
        }
        return rightStart == leftEnd + 2 && ((comma = AceToken.WORDS.get(this.getToken(leftEnd + 1).getWord())).equals(",") || comma.equals("-") || comma.equals("_"));
    }

    public int countVerbs(int start, int end) {
        int count = 0;
        for (int i = start; i < end; ++i) {
            String crt = AceToken.OTHERS.get(this.getToken(i).getPos());
            if (!crt.startsWith("VB")) continue;
            ++count;
        }
        return count;
    }

    public int countCommas(int start, int end) {
        int count = 0;
        for (int i = start; i < end; ++i) {
            String crt = AceToken.WORDS.get(this.getToken(i).getWord());
            if (!crt.equals(",")) continue;
            ++count;
        }
        return count;
    }

    private void readRawBytes(String fileName) throws IOException {
        int c;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        StringBuffer buf = new StringBuffer();
        while ((c = in.read()) >= 0) {
            buf.append((char)c);
        }
        this.mRawBuffer = buf.toString();
        in.close();
    }

    private void readPredictedEntityBoundaries(BufferedReader is) throws IOException {
        String line;
        ArrayList<String> labels = new ArrayList<String>();
        while ((line = is.readLine()) != null) {
            ArrayList<String> tokens = SimpleTokenize.tokenize(line);
            if (tokens.isEmpty()) continue;
            labels.add(tokens.get(0));
        }
        assert (labels.size() == this.mTokens.size());
        int entityId = 1;
        for (int i = 0; i < labels.size(); ++i) {
            if (((String)labels.get(i)).startsWith("B-") || ((String)labels.get(i)).startsWith("I-")) {
                int endToken;
                int startToken = i;
                for (endToken = i + 1; endToken < labels.size() && ((String)labels.get(endToken)).startsWith("I-"); ++endToken) {
                }
                String label = (String)labels.get(startToken);
                int dash = label.indexOf("-", 2);
                if (dash <= 2 || dash >= label.length()) {
                    throw new RuntimeException(label);
                }
                assert (dash > 2 && dash < label.length() - 1);
                String type = label.substring(2, dash);
                String subtype = label.substring(dash + 1);
                this.makeEntity(startToken, endToken, entityId, type, subtype);
                i = endToken - 1;
                ++entityId;
                continue;
            }
            assert (((String)labels.get(i)).equals("O"));
        }
    }

    public AceCharSeq makeCharSeq(int startToken, int endToken) {
        startToken = Math.max(0, startToken);
        while (this.mTokens.get(startToken).getByteStart() < 0) {
            ++startToken;
        }
        endToken = Math.min(endToken, this.mTokens.size());
        while (this.mTokens.get(endToken - 1).getByteStart() < 0) {
            --endToken;
        }
        assert (endToken > startToken);
        String text = this.mRawBuffer.substring(this.mTokens.get(startToken).getRawByteStart(), this.mTokens.get(endToken - 1).getRawByteEnd());
        return new AceCharSeq(text, this.mTokens.get(startToken).getByteStart(), this.mTokens.get(endToken - 1).getByteEnd() - 1);
    }

    private void makeEntity(int startToken, int endToken, int id, String type, String subtype) {
        String eid = this.mId + "-E" + id;
        AceEntity ent = new AceEntity(eid, type, subtype, "SPC");
        this.addEntity(ent);
        AceCharSeq cseq = this.makeCharSeq(startToken, endToken);
        String emid = this.mId + "-E" + id + "-1";
        AceEntityMention entm = new AceEntityMention(emid, "NOM", "NOM", cseq, cseq);
        this.addEntityMention(entm);
        ent.addMention(entm);
    }
}

