theory question_87_3

imports Main

begin

typedecl entity
typedecl event

consts
  Limestone :: "entity ⇒ bool"
  SedimentaryRock :: "entity ⇒ bool"
  Fossils :: "entity ⇒ bool"
  Found :: "entity ⇒ entity ⇒ bool"
  Organisms :: "entity ⇒ bool"
  Remains :: "entity ⇒ entity ⇒ bool"
  Layers :: "entity ⇒ bool"
  Sediment :: "entity ⇒ bool"
  Cover :: "entity ⇒ entity ⇒ bool"
  Formed :: "entity ⇒ event ⇒ bool"
  Compacting :: "entity ⇒ bool"
  Cementing :: "entity ⇒ bool"
  Type :: "entity ⇒ entity ⇒ bool"
  Kind :: "entity ⇒ entity ⇒ bool"
  Specific :: "entity ⇒ bool"
  Purpose :: "entity ⇒ bool"
  Good :: "entity ⇒ entity ⇒ bool"
  Commonly :: "entity ⇒ entity ⇒ bool"
  FoundIn :: "entity ⇒ bool"
  History :: "entity ⇒ bool"
  Occurred :: "entity ⇒ time ⇒ bool"
  Past :: "time ⇒ bool"
  Study :: "entity ⇒ bool"
  Can :: "entity ⇒ (entity ⇒ bool) ⇒ bool"

theorem hypothesis:
  assumes asm: "Limestone x"
  (* Hypothesis: Limestone is the rock type that is useful in studying the history of living organisms. *)
  shows "Useful x ∧  ∃y. History y ∧ Study x y "
proof -
  from asm have "SedimentaryRock x" using explanation_1 by blast
  then have "Type x SedimentaryRock" using explanation_6 by blast
  then have "Kind x SedimentaryRock" by simp
  then have "FoundIn x Fossils" using explanation_4 by blast
  then have "Commonly Fossils (the Kind x)" using explanation_9 by blast
  then have "Useful x" using explanation_7 by blast
  then have "History y" for y where "Past y" using explanation_5 by blast
  then have "Study x y" using explanation_8 by blast
  then show ?thesis using asm `x` `y` by blast
qed

end
