theory question_83_10

imports Main

begin

typedecl entity
typedecl event

consts
  Computers :: "entity ⇒ bool"
  ElectricalCurrentFlowing :: "event ⇒ entity ⇒ bool"
  Runs :: "event ⇒ entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Computers x ∧ ElectricalCurrentFlowing e x"
  (* Hypothesis: Computers run when electrical circuit is working properly. *)
  shows "Runs e x"
proof -
  from asm have "Computers x" by simp
  then have "Runs e x ∨ ¬ Runs e x" by (rule classical)
  from asm have "ElectricalCurrentFlowing e x" by simp
  then have "Runs e x" if "Working e" using explanation_1 by blast
  then show "Runs e x" using asm by simp
  have "Working e" using asm by (rule working\_from\_current\_flowing)
qed

end
