theory question_47_5

imports Main

begin

typedecl entity
typedecl event

consts
  Genes :: "entity ⇒ bool"
  LinkedGenes :: "entity ⇒ entity ⇒ bool"
  InheritedTogether :: "event ⇒ entity ⇒ entity ⇒ bool"
  SameChromosome :: "entity ⇒ entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Genes x ∧ Genes y ∧ SameChromosome x y"
  (* Hypothesis: Genes are inherited together if they are located on the same chromosome. *)
  shows "InheritedTogether e x y"
proof -
  from asm have "Genes x ∧ Genes y ∧ SameChromosome x y" by simp
  then have "LinkedGenes x y" using explanation_1 by blast
  then have "InheritedTogether e x y" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
