theory question_41_0

imports Main

begin

typedecl entity
typedecl event

consts
  EarthTilt :: "event ⇒ bool"
  SeasonChange :: "event ⇒ bool"
  WeatherChange :: "event ⇒ bool"

(* Explanation 1: Earth's tilt on its rotating axis causes seasons to change *)
axiomatization where
  explanation_1: "∀e. EarthTilt e ⟶ SeasonChange e"

(* Explanation 2: Weather changes from season to season *)
axiomatization where
  explanation_2: "∀e1 e2. SeasonChange e1 ⟶ WeatherChange e2"

theorem hypothesis:
  assumes asm: "EarthTilt e"
  (* Hypothesis: Earth's tilt on its rotating axis causes changes in weather. *)
  shows "ChangesInWeather e"
proof -
  from asm have "SeasonChange e" using explanation_1 by blast
  then have "WeatherChange e" using explanation_2 by blast
  then show ?thesis using asm `WeatherChange e` by blast
qed

end
