theory question_4_5

imports Main

begin

typedecl entity

consts
  Ancathostega :: "entity ⇒ bool"
  EarliestTetrapod :: "entity ⇒ bool"
  FourLimbedVertebrate :: "entity ⇒ bool"
  FourLimbs :: "entity ⇒ bool"
  CompleteTetrapod :: "entity ⇒ bool"

(* Explanation 1: Ancathostega is one of the earliest tetrapods found, which are four-limbed vertebrates. *)
axiomatization where
  explanation_1: "∀x. Ancathostega x ⟶ (EarliestTetrapod x ∧ FourLimbedVertebrate x)"

(* Explanation 2: Ancathostega, as an earliest tetrapod, has four limbs. *)
axiomatization where
  explanation_2: "∀x. EarliestTetrapod x ⟶ FourLimbs x"

(* Explanation 3: Ancathostega, being an earliest tetrapod, has four limbs and is also a complete tetrapod. *)
axiomatization where
  explanation_3: "∀x. EarliestTetrapod x ⟶ (FourLimbs x ∧ CompleteTetrapod x)"

theorem hypothesis:
  assumes asm: "Ancathostega x"
  (* Hypothesis: Ancathostega have four limbs. *)
  shows "FourLimbs x"
proof -
  from asm have "EarliestTetrapod x" using explanation_1 by blast
  then have "FourLimbs x" using explanation_2 by blast
  then show ?thesis by simp
qed

end
