theory question_21_8

imports Main

begin

typedecl entity
typedecl event

consts
  Endothermic :: "entity ⇒ bool"
  Tetrapod :: "entity ⇒ bool"
  Vertebrate :: "entity ⇒ bool"
  Belong :: "entity ⇒ entity ⇒ bool"
  Aves :: "entity ⇒ bool"
  is :: "entity ⇒ entity ⇒ bool"
  Classified :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Endothermic tetrapod vertebrates that belong to Class Aves are birds (i.e., Aves). *)
axiomatization where
  explanation_1: "∀x. Endothermic x ∧ Tetrapod x ∧ Vertebrate x ∧ Belong x Aves ⟶ Aves x"

(* Explanation 2: Any entity that is an endothermic tetrapod vertebrate and belongs to Class Aves is also classified as an animal in the class Aves (i.e., Aves x). *)
axiomatization where
  explanation_2: "∀x. Endothermic x ∧ Tetrapod x ∧ Vertebrate x ∧ Belong x Aves ⟶ (∃y. is x y ∧ Classified y Aves)"

theorem hypothesis:
  assumes asm: "Endothermic x ∧ Tetrapod x ∧ Vertebrate x"
  (* Hypothesis: An endothermic tetrapod vertebrate would be animals in the class aves. *)
  shows "Aves x"
proof -
  from asm have "Endothermic x ∧ Tetrapod x ∧ Vertebrate x ∧ Belong x Aves" by auto
  then have "Aves x" using explanation_1 by blast
  then show ?thesis using asm `Aves x` by blast
qed

end
