theory question_88_0

imports Main

begin

typedecl entity
typedecl event

consts
  Displays :: "event ⇒ bool"
  Does :: "event ⇒ bool"
  Gymnast :: "entity ⇒ bool"
  Skills :: "entity ⇒ bool"
  Flip :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Displaying skills with a flip is a rephrasing of "does a flip." *)
axiomatization where
  explanation_1: "∀e. Displays e ⟷ Does e"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip e ∧ Agent e x ∧ Blue f ∧ On x f"
  (* Hypothesis: A gymnast displays their skills with a flip. *)
  shows "∃x y e. Gymnast x ∧ Skills y ∧ Flip e ∧ Displays e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Flip e" by blast
  then have "Displays e" using explanation_1 by blast
  then have "∃y. Skills y ∧ Displays e ∧ Patient e y" by simp
  then have "∃y. Skills y ∧ Flip e ∧ Displays e ∧ Patient e y" by blast
  then show ?thesis using asm by blast
qed

end
