theory question_66_5
imports Main

begin

typedecl entity
typedecl event

consts
  Bartender :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Black :: "entity ⇒ bool"
  WorkUniform :: "entity ⇒ bool"
  Wearing :: "event ⇒ entity ⇒ entity ⇒ bool"
  Dressing :: "event ⇒ entity ⇒ entity ⇒ bool"
  BartenderDressedInBlack :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  Drink :: "entity ⇒ bool"
  MartiniGlass :: "entity ⇒ bool"
  Making :: "event ⇒ entity ⇒ entity ⇒ bool"
  SleevesRolledUp :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A bartender is a person who wears a black work uniform when dressed. *)
axiomatization where
  explanation_1: "∀x. Bartender x ⟶ (Person x ∧ ∃y. (Black y ∧ WorkUniform y) ∧ Wearing e x y)"

(* Explanation 2: A bartender dressed in black refers to the bartender's work uniform being black. *)
axiomatization where
  explanation_2: "∀x. BartenderDressedInBlack x ⟷ Bartender x ∧ ∃y. (Black y ∧ WorkUniform y) ∧ Dressing e x y"

(* Explanation 3: A black work uniform is a kind of black clothing. *)
axiomatization where
  explanation_3: "∀x. BlackWorkUniform x ⟶ (WorkUniform x ∧ Black x)"

theorem hypothesis:
  (* Premise: A male bartender dressed in all black with his sleeves rolled up to elbow height making a drink in a martini glass. *)
  assumes asm: "Male x ∧ Bartender x ∧ Black x ∧ Clothing y ∧ All y ∧ Black y ∧ Dressing e1 x y ∧ SleevesRolledUp x y ∧ Drink z ∧ MartiniGlass z ∧ Making e2 x z"
  (* Hypothesis: A person in black. *)
  shows "∃x. Person x ∧ Black x"
proof -
  from asm have "Bartender x" by auto
  then have "Person x" using explanation_1 by blast
  from asm have "Black x" by auto
  show ?thesis using `Person x` `Black x` by blast
qed

end
