theory question_79_1
imports Main

begin

typedecl entity
typedecl event

consts
  RoughSurface :: "entity ⇒ bool"
  IncreasedRoughness :: "entity ⇒ bool"
  SurfaceOf :: "entity ⇒ entity"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Paper :: "entity ⇒ bool"
  RoughPaper :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Using :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Friction :: "entity ⇒ entity"
  BicycleRamp :: "entity ⇒ bool"
  Used :: "event ⇒ bool"

(* Explanation 1: A rough surface is a surface with increased roughness. *)
axiomatization where
  explanation_1: "∀x. RoughSurface x ⟷ IncreasedRoughness (SurfaceOf x)"

(* Explanation 2: A surface of an object is part of the object. *)
axiomatization where
  explanation_2: "∀x. {SurfaceOf x} ⊆ {y. PartOf x y}"

(* Explanation 3: A paper is a type of object that has a surface. *)
axiomatization where
  explanation_3: "∀x. Paper x ⟶ (∃y. SurfaceOf y ∧ PartOf y x)"

(* Explanation 4: Using rough paper on an object increases the roughness of the object's surface. *)
axiomatization where
  explanation_4: "∀x y e. RoughPaper x ∧ Object y ∧ Using e ∧ Agent e x ∧ Patient e y ⟶ IncreasedRoughness (SurfaceOf y)"

(* Explanation 5: Increased roughness of a surface increases friction on that surface. *)
axiomatization where
  explanation_5: "∀x e. IncreasedRoughness (SurfaceOf x) ∧ Using e ∧ Agent e (SurfaceOf x) ∧ Patient e (Friction x)"

(* Explanation 6: A bicycle ramp is an object that has a surface. *)
axiomatization where
  explanation_6: "∀x. BicycleRamp x ⟶ (∃y. SurfaceOf y ∧ PartOf y x)"

theorem hypothesis:
  assumes asm: "RoughPaper x ∧ BicycleRamp y ∧ Used e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Rough paper should be used on a bicycle ramp to increase friction. *)
  shows "∃e'. Using e' ∧ Agent e' x ∧ Patient e'  Friction y "
proof -
  {
    assume asm: "RoughPaper x ∧ BicycleRamp y ∧ Used e ∧ Agent e x ∧ Patient e y"
    from asm have "RoughPaper x" by simp
    from explanation_3[OF this] obtain z where "SurfaceOf z ∧ PartOf z x" by blast
    from explanation_1[OF this] have "IncreasedRoughness z" by blast
    from asm have "BicycleRamp y" by simp
    from explanation_6[OF this] obtain w where "SurfaceOf w ∧ PartOf w y" by blast
    from explanation_4[OF ‹RoughPaper x›, ‹Object y›, ‹Used e›, ‹Agent e x›, ‹Patient e y›]
    have "IncreasedRoughness w" by blast
    from explanation_5[OF ‹IncreasedRoughness w›, ‹Used e'›, ‹Agent e' w›, "Patient e' Friction y"]
    have "Friction y = Friction (SurfaceOf w)" by blast
    then have "Friction y = Friction (SurfaceOf (PartOf y))" by simp
    then obtain e' where "Using e' ∧ Agent e' x ∧ Patient e' Friction y" by blast
  }
  then show ?thesis using asm by blast
qed

end
