theory question_93_7

imports Main

begin

typedecl entity

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"
  AdultStarfish :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Starfish are a type of echinoderm, and all adults of starfish are echinoderms. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ Echinoderms x ∧ (∀y. AdultStarfish y ⟶ Echinoderms y)"

(* Explanation 3: All adults of starfish exhibit radial symmetry, as they are a type of echinoderm. *)
axiomatization where
  explanation_3: "∀x. AdultStarfish x ⟶ (Starfish x ∧ RadialSymmetry x)"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "AdultStarfish x" by simp
  then have "Echinoderms x" using explanation_2 by blast
  then have "RadialSymmetry x" using explanation_1 by blast
  show ?thesis using asm by blast
qed

end
