theory question_93_1

imports Main

begin

typedecl entity
typedecl event

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"
  AdultStarfish :: "entity ⇒ bool"
  Maturity :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Starfish are a type of echinoderm. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ Echinoderms x"

(* Explanation 3: Adult starfish are starfish that have reached maturity. *)
axiomatization where
  explanation_3: "∀x. AdultStarfish x ⟷ Starfish x ∧ Maturity x"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "AdultStarfish x" by simp
  then have "Starfish x ∧ Maturity x" using explanation_3 by blast
  then have "Starfish x" by simp
  then have "Echinoderms x" using explanation_2 by blast
  then have "AdultEchinoderms x" using explanation_3 and explanation_1 by blast
  then show "RadialSymmetry x" using explanation_1 by blast
qed

end
