theory question_93_0

imports Main

begin

typedecl entity

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  AdultStarfish :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Echinoderms are represented by the starfish. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ Echinoderms x"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "AdultStarfish x" by simp
  then have "Starfish x" using explanation_2 by blast
  then have "Echinoderms x" using explanation_2 by blast
  then have "AdultEchinoderms x" using explanation_1 by blast
  then show "RadialSymmetry x" using explanation_1 by blast
qed

end
