theory question_63_9

imports Main

begin

typedecl entity
typedecl event

consts
  Rocks :: "entity ⇒ bool"
  SedimentaryRocks :: "entity ⇒ bool"
  Deposition :: "event ⇒ bool"
  FormedBy :: "entity ⇒ event ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation 1: Sedimentary rocks are formed exclusively by deposition. *)
axiomatization where
  explanation_1: "∀x e. SedimentaryRocks x ∧ Deposition e ⟷ (∃e. FormedBy x e)"

(* Explanation 2: Sandstone is the only type of sedimentary rock that is formed by deposition. *)
axiomatization where
  explanation_2: "∀x y e. Sandstone x ∧ SedimentaryRocks y ∧ Deposition e ∧ FormedBy y e ⟶ x = y"

theorem hypothesis:
  assumes asm: "Rocks x ∧ Deposition e ∧ FormedBy x e"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Deposition e ∧ FormedBy x e" by simp
  then have "SedimentaryRocks x" using explanation_1 by blast
  then have "∀y e. Sandstone y ∧ Deposition e ∧ FormedBy y e ⟹ x = y" using explanation_2 by blast
  then have "Sandstone x" using asm by blast
  show ?thesis using asm by blast
qed

end
