theory question_98_1
imports Main

begin
typedecl entity
typedecl event
consts
  YoungMan :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  OutOf :: "entity ⇒ entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Water :: "entity ⇒ bool"
  Everywhere :: "entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A young man is a man. *)
axiomatization where
  explanation_1: "∀x. YoungMan x ⟶ Man x"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "YoungMan x ∧ Goggles y ∧ Wearing x  y  ∧ Jumping e1  ∧ Agent e1  x  ∧ OutOf x  p  ∧ Pool p  ∧ Splashing e2  ∧ Agent e2  x  ∧ Water z  ∧ Everywhere z  ∧ Patient e2  z "
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x e p. Man x ∧ Jumping e  ∧ Agent e  x  ∧ OutOf x  p  ∧ Pool p  "
proof -
  from asm have "YoungMan x" by blast
  from this have "Man x" using explanation_1 by blast
  from asm have "Jumping e1" by blast
  from asm have "Agent e1 x" by blast
  from asm have "OutOf x p" by blast
  from asm have "Pool p" by blast
  show ?thesis using `Man x` `Jumping e1` `Agent e1 x` `OutOf x p` `Pool p` by blast
qed

end
