theory question_85_0
imports Main
begin
typedecl entity
typedecl event
consts
  Vendor :: "entity ⇒ bool"
  Seller :: "entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"
  Selling :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Vendor is a seller. *)
axiomatization where
  explanation_1: "∀x. Vendor x ⟶ Seller x"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Vendor x ∧ FlowerCart y Selling e1 ∧ Agent e1 x ∧ Location e1 y ∧ Sidewalk y"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y e. FlowerSeller x ∧ Sidewalk y ∧ Selling e ∧ Agent e x ∧ Location e y"
proof -
  {
    assume "Vendor x ∧ FlowerCart y ∧ Selling e ∧ Agent e x ∧ Location e y"
    from this have "Seller x" using explanation_1 by blast
    from this have "FlowerSeller x"
      by (metis (mono_tags, hide_lams) FlowerCart_def Seller_def Vendor_def)
  }
  from asm have "Vendor x ∧ FlowerCart y ∧ Selling e1 ∧ Agent e1 x ∧ Location e1 y ∧ Sidewalk y" by blast
  then obtain x y e where "Vendor x ∧ FlowerCart y ∧ Selling e ∧ Agent e x ∧ Location e y ∧ Sidewalk y" by blast
  with ‹FlowerSeller x ⟹ Vendor x ∧ FlowerCart y ∧ Selling e ∧ Agent e x ∧ Location e y ∧ Sidewalk y ⟹ FlowerSeller x ∧ Sidewalk y ∧ Selling e ∧ Agent e x ∧ Location e y›
  show ?thesis by blast
qed

end
