theory question_41_0

imports Main

begin
typedecl entity
typedecl event

consts
  Sunny :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  Shining :: "event ⇒ bool"
  the_sun :: event
  Building :: "entity ⇒ bool"
  Red :: "entity ⇒ bool"
  Cars :: "entity ⇒ bool"
  Parked :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If the street is sunny, then the sun is shining. *)
axiomatization where
  explanation_1: "∀x. Sunny x ∧ Street x ⟶ Shining the_sun"

theorem hypothesis:
  (* Premise: A sunny street with a red building, parked cars, and a man walking down the road. *)
  assumes asm: "Sunny x ∧ Street x ∧ Building y ∧ Red y ∧ Cars z ∧ Parked z ∧ Man w ∧ Walking e ∧ Agent e w ∧ On e x"
  (* Hypothesis: The sun is shining. *)
  shows "Shining the_sun"
proof -
  from asm have "Sunny x ∧ Street x" by blast
  then have "Shining the_sun" using explanation_1 by blast
  then show ?thesis by blast
qed

end
