theory question_30_0
imports Main

begin
typedecl entity
typedecl event
consts
  Human :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  TricksOn :: "entity ⇒ entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"
  DoingTricksOn :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: tricks on a skateboard is inferred as doing tricks *)
axiomatization where
  explanation_1: "∀x y e. TricksOn x y ⟹ DoingTricks e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ DoingTricksOn e y ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A human is doing tricks. *)
  shows "∃x e. Human x ∧ DoingTricks e ∧ Agent e x"
proof -
  from asm have "Man x ∧ DoingTricksOn e y ∧ Agent e x ∧ Patient e y" by blast
  then have "Man x ∧ DoingTricks e ∧ Agent e x" using explanation_1 by blast
  then have "Human x ∧ DoingTricks e ∧ Agent e x" using ‹Man x ⟹ Human x› by blast
  then show ?thesis using asm by blast
qed

end
