theory question_26_0
imports Main

begin
typedecl entity
typedecl event

consts
  Policeman :: "entity ⇒ bool"
  Pedestrian :: "entity ⇒ bool"
  Herding :: "event ⇒ bool"
  CrowdOfPeople :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Directing :: "entity ⇒ event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  InvolvedIn :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Directing a crowd of people is another expression of herding pedestrians. *)
axiomatization where
  explanation_1: "∀x y z. Directing x z ∧ CrowdOfPeople y ∧ Herding z ⟷ (Policeman x ∧ CrowdOfPeople y ⟶ (∃e. Agent e x ∧ Patient e y))"

theorem hypothesis:
  (* Premise: A policeman is directing a crowd of people walking. *)
  assumes asm: "Policeman x ∧ CrowdOfPeople y ∧ Walking z ∧ Directing x e ∧ Patient e y ∧ InvolvedIn z y"
  (* Hypothesis: A policeman is herding pedestrians. *)
  shows "∃x y e. Policeman x ∧ Pedestrian y ∧ Herding e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Policeman x ∧ CrowdOfPeople y ∧ Directing x e ∧ Patient e y" by blast
  from explanation_1[OF this] have "Herding e" by blast
  from asm have "Pedestrian y" using CrowdOfPeople_implies_Pedestrian[OF "CrowdOfPeople y"] by blast
  show ?thesis using asm `Policeman x` `Pedestrian y` `Herding e` `Agent e x` `Patient e y` by blast
qed

end
