theory question_73_0

imports Main

begin

typedecl entity
typedecl event

consts
  Condensation :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  Air :: "entity ⇒ bool"

(* Explanation 2: Condensation is water from the air. *)
axiomatization where
  explanation_2: "∀x y. Condensation x ∧ Water y ∧ Air y"

theorem hypothesis:
  assumes asm: "Condensation x ∧ Clouds x "
  (* Hypothesis: Clouds are made of water. *)
  shows "∃y. Water y ∧ Agent x  y "
proof -
  from asm have "Condensation x ∧ Clouds x" by simp
  then obtain e1 where e1: "Condensation x ∧ Water y ∧ Air y" using explanation_2 by blast
  then have "Water y" using e1 by simp
  show ?thesis using asm "Water y" by simp
qed

end
