theory question_94_2

imports Main

begin

typedecl entity
typedecl event

consts
 Boy :: "entity ⇒ bool"
 Building :: "entity ⇒ bool"
 Entering :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 Inside :: "entity ⇒ entity ⇒ bool"

 Person :: "entity ⇒ bool"
 ScaryThing :: "entity ⇒ bool"
 Seeing :: "event ⇒ bool"
 Running :: "event ⇒ bool"

axiomatization where
 explanation_1: "∀x y e. Boy x ∧ Building y ∧ Entering e ∧ Agent e x ∧ Patient e y ⟶ Inside y x"
 explanation_2: "∀x y e. Person x ∧ ScaryThing y ∧ Seeing e ∧ Running e ∧ Agent e x ∧ Patient e y"
 explanation_3: "∀x y e. Person x ∧ ScaryThing y ∧ Running e ∧ Inside y x"

theorem hypothesis:
 (* Premise: A little boy in a bathrobe sits on a bench near the shower in a bathroom. *)
 assumes asm: "LittleBoy x  ∧ Bathrobe y  ∧ Bench z  ∧ Shower z  ∧ Bathroom z  ∧ Sitting e  ∧ Agent e  x  ∧ Patient e  y "
 (* Hypothesis: The boy is inside of the building. *)
 shows "∃x y e. Boy x  ∧ Building y  ∧ Inside y  x "
proof -
 from asm have "LittleBoy x ∧ Bathrobe y ∧ Bench z ∧ Shower z ∧ Bathroom z ∧ Sitting e ∧ Agent e x ∧ Patient e y" by blast
 then have "Person x ∧ ScaryThing y ∧ Seeing e ∧ Running e ∧ Inside y x" using explanation_1 by blast
 then show ?thesis using `Person x` `ScaryThing y` `Seeing e` `Running e` `Inside y x` by blast
qed

end
