theory question_88_0

imports Main

begin

typedecl entity
typedecl event

consts
 Gymnast :: "entity ⇒ bool"
 Skills :: "entity ⇒ bool"
 Flip :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 BlueFlooring :: "entity ⇒ bool"

(* Explanation 1: Displaying skills with a flip is a rephrasing of "does a flip." *)
axiomatization where
 explanation_1: "∀x y e. DisplayingSkillsWithFlip x ⟶ DoesAFlip e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
 (* Premise: Gymnast does a flip on blue flooring. *)
 assumes asm: "Gymnast x  ∧ BlueFlooring z  ∧ Flip e  ∧ Agent e  x  ∧ In e  z "
 (* Hypothesis: A gymnast displays their skills with a flip. *)
 shows "∃x y e. Gymnast x  ∧ Skills y  ∧ Flip e  ∧ Agent e  x  ∧ Patient e  y "
proof -
 from asm have "Gymnast x" by blast
 from this have "Skills y" using explanation_1 by blast
 from asm have "Flip e" by blast
 from this have "Agent e x" and "Patient e y" using explanation_1 by blast
 from asm have "BlueFlooring z" by blast
 show ?thesis using `Gymnast x` `Skills y` `Flip e` `Agent e x` `Patient e y` `BlueFlooring z` by blast
qed

end
