theory question_67_10

imports Main

begin

typedecl entity
typedecl event

consts
 Male :: "entity ⇒ bool"
 Older :: "entity ⇒ bool"
 Participant :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Tour :: "entity ⇒ bool"
 RiverBoatTour :: "entity ⇒ bool"
 MeansOfTransportation :: "entity ⇒ bool"
 Passenger :: "event ⇒ bool"
 Boat :: "entity ⇒ bool"
 Exists :: "entity ⇒ bool"
 Duration :: "event ⇒ bool"
 Present :: "event ⇒ bool"
 Route :: "entity ⇒ bool"
 Follows :: "event ⇒ bool"
 Guide :: "entity ⇒ bool"
 Person :: "entity ⇒ bool"
 GroupOfPeople :: "entity ⇒ bool"
 Start :: "entity ⇒ bool"
 End :: "entity ⇒ bool"
 Location :: "entity ⇒ bool"
 Sit :: "event ⇒ bool"
 Together :: "event ⇒ bool"
 Entity :: "entity ⇒ bool"

(* Premise: Two older males sitting together on a boat. *)
assumes asm: "Male x  ∧ Male y  ∧ Sit e  ∧ Together e "

(* Hypothesis: A river boat tour is an entity. *)
shows "∃x y e. RiverBoatTour x  ∧ Entity e  ∧ Agent e  x "
proof -
 from asm have "Male x ∧ Male y ∧ Sit e ∧ Together e" by blast
 then have "Person x ∧ Person y ∧ Entity e ∧ Agent e x ∧ Agent e y" using explanation_1 by blast
 then have "Duration e ∧ Present e ∧ Route e ∧ Follows e ∧ Guide e ∧ Person x ∧ GroupOfPeople y ∧ Start e ∧ End e ∧ Location e" using explanation_2 by blast
 then have "Boat b ∧ Exists b ∧ Duration e ∧ Present e ∧ Route e ∧ Follows e ∧ Guide e ∧ Person x ∧ GroupOfPeople y ∧ Start e ∧ End e ∧ Location e" using explanation_3 by blast
 then show ?thesis using `RiverBoatTour x ∧ Entity e ∧ Agent e x` by blast
qed

end
