theory question_64_0

imports Main

begin

typedecl entity
typedecl event
consts
  People :: "entity ⇒ bool"
  Food :: "entity ⇒ bool"
  Standing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  FoodVendor :: "entity ⇒ bool"
  Waiting :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A food vendor serves food. *)
axiomatization where
  explanation_1: "∃x y e. FoodVendor x ∧ Food y ∧ Serving e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: People are waiting in line by a food vendor. *)
  assumes asm: "People x ∧ FoodVendor y ∧ Waiting e ∧ Agent e x ∧ InFrontOf x z"
  (* Hypothesis: People stand in line for food. *)
  shows "∃x y e. People x ∧ Food y ∧ Standing e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "People x" by blast
  from this have "Food y" using explanation_1 by blast
  from asm have "Waiting e" by blast
  from this have "Standing e" using `Food y` by blast
  show ?thesis using `People x` `Food y` `Standing e` by blast
qed

end
