theory question_46_0

imports Main

begin

typedecl entity
typedecl event
consts
  Boy :: "entity ⇒ bool"
  Fruit :: "entity ⇒ bool"
  StreetCart :: "event ⇒ bool"
  Selling :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If the boy sells fruit from a street cart, he is a street vendor. *)
axiomatization where
  explanation_1: "∀x y e. Boy x ∧ Fruit y ∧ StreetCart e ∧ Selling e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A boy in an orange shirt sells fruit from a street cart. *)
  assumes asm: "Boy x  ∧ OrangeShirt y  ∧ Fruit z  ∧ StreetCart e  ∧ Selling e  ∧ Agent e  x  ∧ Patient e  z  ∧ Wearing x  y "
  (* Hypothesis: A boy is a street vendor. *)
  shows "∃x e. Boy x  ∧ StreetVendor e  ∧ Selling e  ∧ Agent e  x "
proof -
  from asm have "Boy x" by blast
  from this have "StreetVendor e" using explanation_1 by blast
  show ?thesis using `Boy x` `StreetVendor e` by blast
qed

end
