theory question_30_0

imports Main

begin

typedecl entity
typedecl event
consts
  Human :: "entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"

(* Explanation 1: Tricks on a skateboard is inferred as doing tricks *)
axiomatization where
  explanation_1: "∀x y e. Skateboard(y) ∧ Tricks(e) ∧ Agent(e, x) ∧ On(e, y) ⟶ DoingTricks(e)"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x  ∧ Skateboard y  ∧ DoingTricks e  ∧ Agent e  x  ∧ On e  y "
  (* Hypothesis: A human is doing tricks. *)
  shows "∃x e. Human x  ∧ DoingTricks e  ∧ Agent e  x "
proof -
  from asm have "Man x" by blast
  from asm have "Skateboard y" by blast
  from asm have "DoingTricks e" by blast
  from explanation_1 have "Agent(e, x) ∧ On(e, y)" using `Skateboard(y)` `Tricks(e)` by blast
  show ?thesis using `Human x` `DoingTricks e` `Agent(e, x)` `On(e, y)` by blast
qed

end
