theory question_25_5
```
imports Main

begin

typedecl entity
typedecl event
consts
  Men :: "entity ⇒ bool"
  Train :: "entity ⇒ bool"
  Looking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Wearing :: "event ⇒ entity ⇒ bool"
  RedDoor :: "entity ⇒ bool"

(* Explanation 1: A group of men are looking inside a train. *)
axiomatization where
  explanation_1: "∃x y e. Men x ∧ Train y ∧ Looking e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: The men are wearing bright orange reflective vests. *)
axiomatization where
  explanation_2: "∀x. Men x ⟶ Wearing x BrightOrangeReflectiveVests"

(* Explanation 3: The train has a red door. *)
axiomatization where
  explanation_3: "∀x. Train x ⟶ RedDoor x"

theorem hypothesis:
  (* Premise: Seven men wearing bright orange reflective vests are looking inside the door of a red train. *)
  assumes asm: "Men x  ∧ Train y  ∧ Door z  ∧ Red z  ∧ Wearing x  BrightOrangeReflectiveVests  ∧ Looking e  ∧ Agent e  x  ∧ Patient e  y  ∧ In e  z "
  (* Hypothesis: A group of men are looking in a train. *)
  shows "∃x y e. Men x ∧ Train y ∧ Looking e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Men x" using explanation_1 by blast
  from asm have "Train y" using explanation_3 by blast
  from asm have "Door z" using explanation_3 by blast
  from asm have "Looking e" using explanation_1 by blast
  show ?thesis using `Men x` `Train y` `Door z` `Looking e` by blast
qed

end