theory question_72_0

imports Main

begin

typedecl entity
typedecl event

consts
  Friction :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Acts :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Counter :: "event ⇒ bool"
  Motion :: "event ⇒ bool"
  Touching :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Wagon :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Reduce :: "event ⇒ bool"
  Stop :: "event ⇒ bool"
  Resist :: "event ⇒ bool"
  Thing :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Move :: "event ⇒ bool"
  Over :: "event ⇒ entity ⇒ bool"
  Child :: "entity ⇒ bool"
  Hill :: "entity ⇒ bool"
  Rides :: "event ⇒ bool"
  Down :: "event ⇒ entity ⇒ bool"
  Comes :: "event ⇒ bool"
  Acting :: "event ⇒ bool"
  Causing :: "event ⇒ bool"

(* Explanation 1: Friction acts to counter the motion of two objects when their surfaces are touching. *)
axiomatization where
  explanation_1: "∀x y z e1 e2 e3. Friction x ∧ Object y ∧ Object z ∧ Acts e1 ∧ Agent e1 x ∧ Counter e2 ∧ Agent e2 x ∧ Motion e2 ∧ Touching e3 ∧ Agent e3 y ∧ Patient e3 z"

(* Explanation 2: A surface is a part of an object. *)
axiomatization where
  explanation_2: "∀x y. Surface x ∧ Object y ⟶ PartOf x y"

(* Explanation 3: A wagon is a kind of vehicle. *)
axiomatization where
  explanation_3: "∀x. Wagon x ⟶ Vehicle x"

(* Explanation 4: Counter means reduce; stop; resist. *)
axiomatization where
  explanation_4: "∀e1 e2 e3 e4. Counter e1 ⟷ Reduce e2 ∧ Stop e3 ∧ Resist e4"

(* Explanation 5: Riding something is to move that thing over a surface. *)
axiomatization where
  explanation_5: "∀x y e1 e2. Thing x ∧ Surface y ∧ Riding e1 ∧ Agent e1 x ⟶ Move e2 ∧ Agent e2 x ∧ Over e2 y"

(* Explanation 6: Riding is a kind of motion. *)
axiomatization where
  explanation_6: "∀e. Riding e ⟶ Motion e"

theorem hypothesis:
  (* Premise: A child rides a wagon down a hill. *)
  (* Premise: Eventually, the wagon comes to a stop. *)
  assumes asm: "Child x ∧ Wagon y ∧ Hill z ∧ Rides e ∧ Agent e x ∧ Patient e y ∧ Down e z" 
                "∃x e1 e2. Wagon x ∧ Comes e1 ∧ Agent e1 x ⟶ Stop e2 ∧ Patient e2 x"
  (* Hypothesis: Friction acting on the wagon is responsible for causing the wagon to stop. *)
  shows "∃x y e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Causing e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Stop e2"
proof -
  from asm have "Wagon y" by simp
  then have "Vehicle y" using explanation_3 by simp
  then have "Object y" using explanation_2 by simp
  then obtain e1 where e1: "Acts e1 ∧ Agent e1 x ∧ Counter e2 ∧ Agent e2 x ∧ Motion e2 ∧ Touching e3 ∧ Agent e3 y ∧ Patient e3 z" using explanation_1 by blast
  then have "Friction x" using explanation_1 by blast
  then have "Stop e2" using explanation_4 by blast
  then have "Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Causing e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Stop e2" using e1 by simp
  show ?thesis using asm `Friction x` `Wagon y` `Acting e1` `Agent e1 x` `Patient e1 y` `Causing e2` `Agent e2 x` `Patient e2 y` `Stop e2` by blast
qed

end
