theory question_63_10

imports Main

begin

typedecl entity
typedecl event

consts
  Fossil :: "entity ⇒ bool"
  WaterAnimalOrPlant :: "entity ⇒ bool"
  Place :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  CoveredByWater :: "entity ⇒ bool"
  TrilobiteFossil :: "entity ⇒ bool"
  Ohio :: "entity ⇒ bool"

(* Explanation 1: If a fossil of a water animal or plant is found in a place, then that place used to be covered by water in the past. *)
axiomatization where
  explanation_1: "∀x y e. Fossil x ∧ WaterAnimalOrPlant x ∧ Place y ∧ Found e ∧ Agent e x ∧ Patient e y ⟶ CoveredByWater y"

(* Explanation 2: A trilobite fossil is a kind of fossil that is a water animal or plant. *)
axiomatization where
  explanation_2: "∀x. TrilobiteFossil x ⟶ Fossil x ∧ WaterAnimalOrPlant x"  

theorem hypothesis:
  (* Premise: the fossils of extinct sea animals called trilobites are found in ohio. *)
  assumes asm: "TrilobiteFossil x ∧ Ohio y ∧ Found e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Ohio was once covered by water. *)
  shows "∃x. Ohio x ∧ CoveredByWater x"
proof -
  from asm have "Fossil x ∧ WaterAnimalOrPlant x" using explanation_2 by blast
  then have "CoveredByWater y" using explanation_1 asm by blast
  then show ?thesis using asm `CoveredByWater y` by blast
qed

end
