theory question_13_1
imports Main
begin

typedecl entity
typedecl event

consts
  Liquid :: "entity ⇒ bool"
  Gas :: "entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  Change :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Adding :: "event ⇒ bool"
  BoilingEvaporation :: "event ⇒ event ⇒ bool"
  Heating :: "event ⇒ bool"
  Water :: "entity ⇒ bool"
  Disappears :: "event ⇒ bool"
  Probably :: "bool ⇒ bool"
  Evaporated :: "event ⇒ bool"
  StateOfMatter :: "entity ⇒ bool"
  Pan :: "entity ⇒ bool"
  State :: "entity ⇒ bool"
  Gone :: "event ⇒ bool"
  Changing :: "event ⇒ bool"
  Example :: "event ⇒ event ⇒ bool"

(* Explanation 1: boiling;evaporation means change from a liquid into a gas by adding heat energy. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Liquid x ∧ Gas y ∧ HeatEnergy z ∧ Change e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Adding e2 ∧ Agent e2 z ⟶ BoilingEvaporation e1 e2"

(* Explanation 2: heating means adding heat energy. *)
axiomatization where
  explanation_2: "∀x y e. HeatEnergy x ∧ Adding e ⟶ Heating e"

(* Explanation 3: water is a kind of liquid. *)
axiomatization where
  explanation_3: "∀x. Water x ⟶ Liquid x"

(* Explanation 4: if a liquid disappears then that liquid probably evaporated. *)
axiomatization where
  explanation_4: "∀x e1 e2. Liquid x ∧ Disappears e1 ∧ Agent e1 x ⟶ Probably (Evaporated e2 ∧ Agent e2 x)"

(* Explanation 5: liquid is a kind of state of matter. *)
axiomatization where
  explanation_5: "∀x. Liquid x ⟶ StateOfMatter x"

(* Explanation 6: gas is a kind of state of matter. *)
axiomatization where
  explanation_6: "∀x. Gas x ⟶ StateOfMatter x"

theorem hypothesis:
  assumes asm: "Pan x ∧ Water y ∧ State z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 ∧ Agent e2 y"
  (* Hypothesis: Heating a pan of water until the water is all gone is an example of matter changing state. *)
  shows "∃x y z e1 e2 e3. Pan x ∧ Water y ∧ State z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 ∧ Agent e2 y ∧ Changing e3 ∧ Agent e3 y ∧ Patient e3 z ∧ Example e1 e3"
proof -
  from asm have "Water y" by simp
  then have "Liquid y" using explanation_3 by simp
  then have "HeatEnergy x" using explanation_2 by blast
  then have "Gas z" using explanation_1 by blast
  then have "Probably (Evaporated e2 ∧ Agent e2 y)" using explanation_4 by blast
  then have "StateOfMatter y" using explanation_5 by simp
  then have "StateOfMatter z" using explanation_6 by simp
  then have "Changing e3 ∧ Agent e3 y ∧ Patient e3 z" by simp
  then show ?thesis using asm `Changing e3` `Agent e3 y` `Patient e3 z` by blast
qed

end
