theory question_1_0

imports Main

begin

typedecl entity
typedecl event

consts
  Hypothesis :: "entity ⇒ bool"
  ScientificGuess :: "entity ⇒ bool"
  CauseAndEffect :: "event ⇒ bool"
  Event :: "event ⇒ bool"

(* Explanation 1: Hypothesis means scientific guess about the cause and effect of an event. *)
axiomatization where
  explanation_1: "∀x y. Hypothesis x ⟷ ScientificGuess x ∧ CauseAndEffect y ∧ Event y"

theorem hypothesis:
  assumes asm: "ScientificGuess x ∧ CauseAndEffect y ∧ Event y"
  (* Hypothesis: Hypothesis(x) ⟷ ScientificGuess(x) ∧ CauseAndEffect(y) ∧ Event(y) *)
  shows "Hypothesis x"
proof -
  from asm have "ScientificGuess x ∧ CauseAndEffect y ∧ Event y" by simp
  then show ?thesis using explanation_1 by blast
qed

end
