theory question_87_0

imports Main

begin

typedecl entity
typedecl event

consts
  Tunicates :: "entity ⇒ bool"
  Reproduce :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Sexually :: "event ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  Classifies :: "event ⇒ bool"
  Tunicate :: "entity ⇒ bool"
  NonTunicate :: "entity ⇒ bool"

(* Explanation 1: Tunicates reproduce sexually. *)
axiomatization where
  explanation_1: "∀x e. Tunicates x ∧ Reproduce e ∧ Agent e x ∧ Sexually e"

(* Explanation 2: Bulbs are classifies as tunicate or non-tunicate. *)
axiomatization where
  explanation_2: "∀x e. Bulbs x ∧ Classifies e ∧ Agent e x ∧ (Tunicate x ∨ NonTunicate x)"  

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "∃x e. Bulbs x ∧ Reproduce e ∧ Agent e x ∧ Sexually e"
proof -
  from asm have "Bulbs x" by simp
  then obtain e1 where e1: "Classifies e1 ∧ Agent e1 x ∧ (Tunicate x ∨ NonTunicate x)" using explanation_2 by blast
  then have "Tunicates x" using explanation_1 by blast
  obtain e2 where e2: "Reproduce e2 ∧ Agent e2 x ∧ Sexually e2" using explanation_1 `Tunicates x` by blast
  show ?thesis using asm e2 by blast
qed

end
