theory question_88_1

imports Main

begin
typedecl entity
typedecl event

consts
  Gymnast :: "entity ⇒ bool"
  Skills :: "entity ⇒ bool"
  Flip :: "entity ⇒ bool"
  Doing :: "event ⇒ bool"
  Display :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Flooring :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  Does :: "event ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Displays :: "event ⇒ bool"

(* Explanation 1: Doing a flip is a way for a gymnast to display their skills. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Gymnast x ∧ Skills y ∧ Flip y ∧ Doing e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Display e2 ∧ Agent e2 x ∧ Patient e2 y"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip y ∧ Flooring z ∧ Blue z ∧ Does e ∧ Agent e x ∧ Patient e y ∧ On e z"
  (* Hypothesis: A gymnast displays their skills with a flip *)
  shows "∃x y e. Gymnast x ∧ Skills y ∧ Flip y ∧ Displays e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Gymnast x ∧ Flip y ∧ Does e ∧ Agent e x ∧ Patient e y" by blast
  then have "Gymnast x ∧ Skills y ∧ Flip y ∧ Displays e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
