theory question_24_0

imports Main

begin
typedecl entity

consts
  CuteCouple :: "entity ⇒ bool"
  Couple :: "entity ⇒ bool"
  Club :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A cute couple at a club means a couple is at a club. *)
axiomatization where
  explanation_1: "∀x y. CuteCouple x ∧ Club y ∧ At x y ⟶ Couple x ∧ At x y"

theorem hypothesis:
  (* Premise: A cute couple at a club *)
  assumes asm: "CuteCouple x ∧ Club y ∧ At x y"
  (* Hypothesis: The couple is at a club. *)
  shows "∃x y. Couple x ∧ Club y ∧ At x y"
proof -
  from asm have "CuteCouple x ∧ Club y ∧ At x y" by blast
  then have "Couple x ∧ At x y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
