theory question_75_0
imports Main
begin

typedecl entity
typedecl event

consts
  RollingSoccerBall :: "entity ⇒ bool"
  Slow :: "event ⇒ bool"
  Down :: "event ⇒ bool"
  SpeedDecrease :: "event ⇒ bool"
  SlowingDown :: "event ⇒ event ⇒ entity ⇒ bool"
  Friction :: "event ⇒ bool"
  Acts :: "event ⇒ bool"
  Counter :: "event ⇒ bool"
  Motion :: "event ⇒ bool"
  Objects :: "entity ⇒ entity ⇒ bool"
  SurfacesTouching :: "event ⇒ entity ⇒ entity ⇒ bool"
  ActsToCounter :: "event ⇒ event ⇒ entity ⇒ entity ⇒ bool"
  Touch :: "event ⇒ bool"
  Contact :: "event ⇒ bool"
  TouchMeansContact :: "event ⇒ event ⇒ entity ⇒ entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Pushing :: "event ⇒ bool"
  KindOf :: "event ⇒ event ⇒ bool"
  Pulling :: "event ⇒ bool"
  Counter :: "event ⇒ bool"
  Reduce :: "event ⇒ bool"
  Stop :: "event ⇒ bool"
  Resist :: "event ⇒ bool"
  ReduceMeansDecrease :: "event ⇒ event ⇒ bool"
  Rolling :: "event ⇒ bool"
  Ball :: "entity ⇒ bool"
  Force :: "event ⇒ bool"
  Type :: "entity ⇒ bool"
  SynonymousWith :: "entity ⇒ entity ⇒ bool"
  
(* Hypothesis: Frictional forces slowing down a rolling soccer ball is a type of force that requires contact between two objects for one to push or pull the other. *)
theorem hypothesis:
  assumes asm: "RollingSoccerBall b ∧ Slow e1 ∧ Down e2 ∧ SpeedDecrease e1 ∧ SpeedDecrease e2"
  shows "∃e1 e2 b o1 o2. RollingSoccerBall b ∧ Slow e1 ∧ Down e2 ∧ SpeedDecrease e1 ∧ SpeedDecrease e2 ∧ SlowingDown e1 e2 b ∧ Friction e1 ∧ Acts e1 ∧ Counter e2 ∧ Motion e2 ∧ Objects o1 o2 ∧ SurfacesTouching e2 o1 o2 ∧ Touch e1 ∧ Contact e2 ∧ Pushing e1 ∧ Pulling e1 ∧ Counter e2 ∧ Reduce e2 ∧ Stop e2 ∧ Resist e2 ∧ Rolling e1 ∧ Ball b ∧ Force e1 ∧ Type o2 ∧ Surface o1 ∧ Object o2 ∧ PartOf o1 o2 ∧ KindOf Pushing Motion ∧ KindOf Pulling Motion ∧ KindOf Counter Reduce ∧ KindOf Counter Stop ∧ KindOf Counter Resist ∧ KindOf ReduceMeansDecrease ∧ KindOf Rolling Motion ∧ KindOf Ball Object ∧ KindOf Friction Force ∧ Type o2 ∧ SynonymousWith  Type o2 "
proof -
  from asm have "RollingSoccerBall b" by simp
  from asm have "Slow e1" by simp
  from asm have "Down e2" by simp
  from asm have "SpeedDecrease e1" by simp
  from asm have "SpeedDecrease e2" by simp
  have "Rolling b" using explanation_9 `RollingSoccerBall b` by blast
  have "Ball b" using explanation_10 `RollingSoccerBall b` by blast
  have "Force e1" using explanation_11 `Friction e1` by blast
  have "KindOf Pushing Motion" using explanation_5 by blast
  have "KindOf Pulling Motion" using explanation_6 by blast
  have "KindOf Counter Reduce" using explanation_7 by blast
  have "KindOf Counter Stop" using explanation_7 by blast
  have "KindOf Counter Resist" using explanation_7 by blast
  have "KindOf ReduceMeansDecrease" using explanation_8 by blast
  have "KindOf Rolling Motion" using explanation_9 by blast
  have "KindOf Ball Object" using explanation_10 by blast
  have "KindOf Friction Force" using explanation_11 by blast
  have "Type o2" using explanation_12 `Object o2` by blast
  have "Surface o1" using explanation_4 `SurfacesTouching e2 o1 o2` by blast
  have "Object o2" using explanation_4 `SurfacesTouching e2 o1 o2` by blast
  have "PartOf o1 o2" using explanation_4 `SurfacesTouching e2 o1 o2` by blast
  have "Touch e1" using explanation_4 by blast
  have "Contact e2" using explanation_4 by blast
  have "Pushing e1" using explanation_5 by blast
  have "Pulling e1" using explanation_6 by blast
  have "Counter e2" using explanation_7 by blast
  have "Reduce e2" using explanation_7 by blast
  have "Stop e2" using explanation_7 by blast
  have "Resist e2" using explanation_7 by blast
  have "Acts e1" using explanation_2 `SurfacesTouching e2 o1 o2` by blast
  have "Counter e2" using explanation_2 `SurfacesTouching e2 o1 o2` by blast
  have "Motion e2" using explanation_2 `SurfacesTouching e2 o1 o2` by blast
  have "Objects o1 o2" using explanation_2 `SurfacesTouching e2 o1 o2` by blast
  have "ActsToCounter e1 e2 b o1 o2" using explanation_2 `SurfacesTouching e2 o1 o2` by blast
  have "SlowingDown e1 e2 b" using explanation_2 `SurfacesTouching e2 o1 o2` by blast
  have "Friction e1" using explanation_2 `SurfacesTouching e2 o1 o2` by blast
  show ?thesis using asm `Rolling b` `Slow e1` `Down e2` `SpeedDecrease e1` `SpeedDecrease e2` `SlowingDown e1 e2 b` `Friction e1` `Acts e1` `Counter e2` `Motion e2` `Objects o1 o2` `SurfacesTouching e2 o1 o2` `Touch e1` `Contact e2` `Pushing e1` `Pulling e1` `Counter e2` `Reduce e2` `Stop e2` `Resist e2` `Rolling e1` `Ball b` `Force e1` `Type o2` `Surface o1` `Object o2` `PartOf o1 o2` `KindOf Pushing Motion` `KindOf Pulling Motion` `KindOf Counter Reduce` `KindOf Counter Stop` `KindOf Counter Resist` `KindOf ReduceMeansDecrease` `KindOf Rolling Motion` `KindOf Ball Object` `KindOf Friction Force` by blast
qed

end
