theory question_67_5
imports Main
begin

typedecl entity
typedecl event

consts
  LightBulbSystem :: "entity ⇒ bool"
  PoweredBy :: "entity ⇒ entity ⇒ bool"
  Electricity :: "entity"
  Conversion :: "event ⇒ bool"
  Involves :: "event ⇒ bool"
  Changing :: "event ⇒ bool"
  From :: "event ⇒ entity ⇒ bool"
  Into :: "event ⇒ entity ⇒ bool"
  System :: "event ⇒ entity ⇒ bool"
  ElectricalEnergy :: "entity"
  LightEnergy :: "entity"
  LightBulb :: "entity"
  Energy :: "entity"
  Changes :: "event ⇒ bool"
  OneForm :: "entity"
  AnotherForm :: "entity"
  TurnedOn :: "event ⇒ bool"

(* Explanation 1: A light bulb system is powered by electricity. *)
axiomatization where
  explanation_1: "∃e. LightBulbSystem(e) ∧ PoweredBy(e, Electricity)"

(* Explanation 2: Conversion in a light bulb system involves changing electrical energy into light energy. *)
axiomatization where
  explanation_2: "∃e. Conversion(e) ∧ Involves(e) ∧ Changing(e) ∧ From(e, ElectricalEnergy) ∧ Into(e, LightEnergy) ∧ System(e, LightBulb)"

theorem hypothesis:
  (* Premise: when a light bulb is turned on, energy changes from one form to another. *)
  assumes asm: "LightBulb x ∧ TurnedOn x ∧ Energy y ∧ Changes y ∧ From y OneForm ∧ Into y AnotherForm"
  (* Hypothesis: The change best described is from electrical energy to light energy. *)
  shows "∃e. Changes e ∧ Best e ∧ Described e ∧ From e ElectricalEnergy ∧ Into e LightEnergy"
proof -
  from asm have "LightBulbSystem x" using explanation_1 by blast
  then obtain e where e: "Conversion e ∧ Involves e ∧ Changing e ∧ From e ElectricalEnergy ∧ Into e LightEnergy ∧ System e x" using explanation_2 by blast
  have conclusion: "Conversion e ∧ Involves e ∧ Changing e ∧ From e ElectricalEnergy ∧ Into e LightEnergy" using e by simp
  show ?thesis using conclusion by blast
qed

end
