theory question_61_5

imports Main

begin

typedecl entity
typedecl event

consts
  SolarSystem :: "entity ⇒ bool"
  Body :: "entity ⇒ bool"
  Largest :: "entity ⇒ bool"
  Sun :: "entity ⇒ bool"
  Is :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: The Sun is the largest body in our solar system. *)
axiomatization where
  explanation_1: "∀x y. SolarSystem x ∧ Body y ∧ Largest y ∧ Sun y ∧ Is x y"

theorem hypothesis:
  assumes asm: "SolarSystem x ∧ Body y ∧ Largest y ∧ Sun y"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "∃x y. SolarSystem x ∧ Body y ∧ Largest y ∧ Sun y ∧ Is x y"
proof -
  from asm have "SolarSystem x ∧ Body y ∧ Largest y ∧ Sun y" by simp
  then have "Is x y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
