theory question_60_5
imports Main
begin

typedecl entity
typedecl event

consts
  Melting :: "event ⇒ bool"
  Solid :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  HeatEnergy :: "event ⇒ bool"
  Adding :: "event ⇒ bool"
  Agent :: "event ⇒ event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Change :: "event ⇒ bool"
  Ice :: "entity ⇒ bool"
  Beaker :: "entity ⇒ bool"
  Volume :: "entity ⇒ int ⇒ bool"
  Placed :: "event ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"
  Windowsill :: "entity ⇒ bool"
  Time :: "event ⇒ bool"
  SeveralHours :: "event"

(* Explanation 1: Melting means changing from a solid into a liquid by adding heat energy. *)
axiomatization where
  explanation_1: "∀e1 e2 x. Melting e1 ∧ Solid x ∧ Liquid x ∧ HeatEnergy e2 ∧ Adding e2 ∧ Agent e2 e1 ∧ Patient e2 x ⟶ Change e1"

theorem hypothesis:
  (* Premise: a beaker containing 50 milliliters of ice is placed on a windowsill. *)
  assumes asm: "Beaker x ∧ Ice x ∧ Volume x 50 ∧ Placed e ∧ Patient e x ∧ Location e x ∧ Windowsill x"
  (* Hypothesis: The mass of the ice did not change when it melted. *)
  shows "∃x e. Ice x ∧ Melting e ∧ ¬ Change e ∧ Patient e x"
proof -
  from asm have "Ice x" by simp
  then obtain e where e: "Melting e ∧ Patient e x" using explanation_1 by blast
  then have "¬ Change e" using e by simp
  have conclusion: "Melting e ∧ ¬ Change e ∧ Patient e x" using e `Ice x` by blast
  show ?thesis using conclusion by blast
qed

end
