theory question_85_5
imports Main
begin

typedecl entity
typedecl event

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  PressureReceptors :: "entity ⇒ bool"
  Skin :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  MainlyIn :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Pacinian corpuscles are a type of pressure receptors. *)
axiomatization where
  explanation_1: "∀x. PacinianCorpuscles x ⟶ PressureReceptors x"

(* Explanation 2: Pacinian corpuscles, as pressure receptors, are found mainly in the skin. *)
axiomatization where
  explanation_2: "∀x y. PacinianCorpuscles x ∧ PressureReceptors x ∧ Skin y ∧ Found e ∧ MainlyIn e y"

(* Explanation 3: Pacinian corpuscles, as pressure receptors specifically located mainly in the skin, indicate their role in sensing pressure. *)
axiomatization where
  explanation_3: "∀x y e. PacinianCorpuscles x ∧ PressureReceptors x ∧ Skin y ∧ Located e ∧ MainlyIn e y ∧ Indicate e ∧ Role e SensingPressure"

(* Explanation 4: Pacinian corpuscles, as pressure receptors specifically located mainly in the skin, suggest their function in detecting pressure stimuli. *)
axiomatization where
  explanation_4: "∀x y e. PacinianCorpuscles x ∧ PressureReceptors x ∧ Skin y ∧ Located e ∧ MainlyIn e y ∧ Suggest e ∧ Function e DetectingPressureStimuli"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x ∧ Skin y"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "∃e. PacinianCorpuscles x ∧ Skin y ∧ Found e ∧ MainlyIn e y"
proof -
  from asm have "PacinianCorpuscles x ∧ Skin y" by simp
  then have "PressureReceptors x" using explanation_1 by blast
  then obtain e where e: "Found e ∧ MainlyIn e y" using explanation_2 by blast
  have conclusion: "Found e ∧ MainlyIn e y" using e by simp
  show ?thesis using asm conclusion `PacinianCorpuscles x` `Skin y` by blast
qed

end
