theory question_85_1
imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  Skin :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Location :: "event ⇒ entity ⇒ entity ⇒ bool"
  Mainly :: "event ⇒ bool"
  PacinianCorpuscles :: "entity ⇒ bool"

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x y. PressureReceptors x ∧ Skin y ⟶ (∃e. Found e ∧ Location e x y ∧ Mainly e)"

(* Explanation 2: Pacinian corpuscles are a specific type of pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟶ SpecificTypeOf x PressureReceptors"

(* Explanation 3: Pacinian corpuscles being a type of pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_3: "∀x y. PacinianCorpuscles x ∧ PressureReceptors y ⟶ (∃e. Found e ∧ Location e x y ∧ Mainly e)"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x ∧ Skin y"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "∃e. Found e ∧ Location e x y ∧ Mainly e"
proof -
  from asm have "PacinianCorpuscles x" and "Skin y" by auto
  then obtain e where e: "Found e ∧ Location e x y ∧ Mainly e" using explanation_3 by blast
  then show ?thesis using e by blast
qed

end
