theory question_40_1

imports Main

begin

typedecl entity
typedecl event

consts
  LightBulbs :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  Convert :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Into :: "event ⇒ entity ⇒ bool"
  LightEnergy :: "entity"
  HeatEnergy :: "entity"
  Energy :: "entity ⇒ bool"
  Other :: "entity ⇒ bool"

(* Explanation 1: Some light bulbs convert electricity into light and heat energy. *)
axiomatization where
  explanation_1: "∃x y e. LightBulbs x ∧ Electricity y ∧ Convert e ∧ Agent e x ∧ Patient e y ∧ Into e LightEnergy ∧ Into e HeatEnergy"

(* Explanation 2: Light bulbs can also convert other forms of energy into light and heat energy. *)
axiomatization where
  explanation_2: "∃x y z e. LightBulbs x ∧ Energy y ∧ Other z ∧ Convert e ∧ Agent e x ∧ Patient e y ∧ Patient e z ∧ Into e LightEnergy ∧ Into e HeatEnergy"

theorem hypothesis:
  assumes asm: "LightBulbs x ∧ Energy y ∧ Other z"
  (* Hypothesis: Some light bulbs convert other energy into light and heat energy. *)
  shows "∃x y z e. LightBulbs x ∧ Energy y ∧ Other z ∧ Convert e ∧ Agent e x ∧ Patient e y ∧ Patient e z ∧ Into e LightEnergy ∧ Into e HeatEnergy"
proof -
  from asm obtain x y z e where "LightBulbs x ∧ Energy y ∧ Other z ∧ Convert e ∧ Agent e x ∧ Patient e y ∧ Patient e z ∧ Into e LightEnergy ∧ Into e HeatEnergy" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
