theory question_96_1

imports Main

begin
typedecl entity
typedecl event

consts
  Children :: "entity ⇒ bool"
  Adults :: "entity ⇒ bool"
  GroupOfPeople :: "entity ⇒ bool"
  Swimming :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  LargePoolWithRedStaircase :: "event ⇒ bool"

(* Explanation 1: Children and adults collectively form a group of people. *)
axiomatization where
  explanation_1: "∀x. Children x ∨ Adults x ⟶ GroupOfPeople x"

theorem hypothesis:
  (* Premise: Children and adults swim in a large pool with a red staircase. *)
  assumes asm: "Children x ∧ Adults y ∧ LargePoolWithRedStaircase e ∧ Swimming e ∧ Agent e x ∧ Agent e y"
  (* Hypothesis: A group of people are swimming. *)
  shows "∃x e. GroupOfPeople x ∧ Swimming e ∧ Agent e x"
proof -
  from asm have "Children x ∨ Adults x" by blast
  then have "GroupOfPeople x" using explanation_1 by blast
  then show ?thesis using `GroupOfPeople x` by blast
qed

end
