theory question_89_1
imports Main

begin
typedecl entity
typedecl event

consts
  EarlyFall :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  MountainBiking :: "entity ⇒ bool"
  Bicycling :: "event ⇒ bool"
  Woods :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation 1: Early fall is equivalent to autumn. *)
axiomatization where
  explanation_1: "∀x. EarlyFall x ⟶ Autumn x"

(* Explanation 2: Mountain biking in the early fall is the same as mountain biking in autumn. *)
axiomatization where
  explanation_2: "∀x. MountainBiking x ∧ EarlyFall x ⟷ MountainBiking x ∧ Autumn x"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking e ∧ Forest x ∧ EarlyFall y ∧ In x y ∧ In e x"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y e. Bicycling e ∧ Woods x ∧ Autumn y ∧ In x y ∧ In e x"
proof -
  from asm have "MountainBiking e ∧ Forest x ∧ Autumn y ∧ In x y" using explanation_1 by blast
  then have "Bicycling e ∧ Woods x ∧ Autumn y ∧ In x y ∧ In e x" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
